// file: spec_plot_constants.h
//

// make sure definitions are made only once
//

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#define __ISIP_SPEC_PLOT_CONSTANTS
 
// isip include files
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif

// define the class name
//
#define SPEC_WIDGET_NAME (char_1*)"spectrogram_plot"

// define the configuration string
//
#define SPEC_CONFIG_STRING (char_1*)"configure"

// define the error string returned from Tk_NameOfRelief
//
#define SPEC_RELIEF_ERROR_NAME (char_1*)"unknown relief"

// define parameter strings
//
#define SPEC_AUDIO_FILE_PARAM (char_1*)"-file"
#define SPEC_NUM_CHANS_PARAM (char_1*)"-num_chans"
#define SPEC_NUM_BYTES_PARAM (char_1*)"-num_bytes"
#define SPEC_DISPLAY_CHAN_PARAM (char_1*)"-display_chan"
#define SPEC_SAMPLE_FREQ_PARAM (char_1*)"-sample_freq"
#define SPEC_START_TIME_PARAM (char_1*)"-start_time"
#define SPEC_END_TIME_PARAM (char_1*)"-end_time"
#define SPEC_SWAP_BYTES_PARAM (char_1*)"-swap_bytes"
#define SPEC_HEIGHT_PARAM (char_1*)"-height"
#define SPEC_WIDTH_PARAM (char_1*)"-width"
#define SPEC_DEPTH_PARAM (char_1*)"-depth"
#define SPEC_X_LOC_PARAM (char_1*)"-x_loc"
#define SPEC_Y_LOC_PARAM (char_1*)"-y_loc"
#define SPEC_BORDERWIDTH (char_1*)"-borderwidth"
#define SPEC_BD (char*)"-bd"
#define SPEC_PADX (char*)"-padx"
#define SPEC_PADY (char*)"-pady"
#define SPEC_FFT_ORDER (char*)"-fft_order"
#define SPEC_WINLEN (char*)"-winlen"
#define SPEC_FRAMELEN (char*)"-framelen"
#define SPEC_PREEMPH (char*)"-preemph_coeff"
#define SPEC_PREFLAG (char*)"-use_preemph"
#define SPEC_WIN_OPTION (char*)"-filter"
#define SPEC_FOREGROUND (char*)"-foreground"
#define SPEC_FG (char*)"-fg"
#define SPEC_BACKGROUND (char*)"-background"
#define SPEC_BG (char*)"-bg"
#define SPEC_HGLTCOLOR (char*)"-highlightcolor"
#define SPEC_HGLTBACKGROUND (char*)"-highlightbackground"
#define SPEC_RELIEF (char*)"-relief"
#define SPEC_FFT_LEN (char*)"-fft_len"
#define SPEC_CLEAR (char*)"-clear"
#define SPEC_BRIGHTNESS (char*)"-brightness"
#define SPEC_CONTRAST (char*)"-contrast"
#define SPEC_MAX_RATE (char*)"-max_freq"
#define SPEC_AMP_SCALE_FACTOR (char*)"-amp_scale"

// define the default widget characteristics
//
#define SPEC_DEFAULT_FOREGROUND_COLOR (char_1*)"black"
#define SPEC_DEFAULT_BACKGROUND_COLOR (char_1*)"white"
#define SPEC_DEFAULT_HIGHLIGHT_COLOR (char_1*)"red"
#define SPEC_DEFAULT_BORDERWIDTH (char_1*)"2"
#define SPEC_DEFAULT_RELIEF_NAME (char_1*)"ridge"
#define SPEC_DEFAULT_RELIEF TK_RELIEF_RIDGE
#define SPEC_DEFAULT_HIGHLIGHT_THICKNESS (char_1*)"2"
#define SPEC_DEFAULT_HORIZONTAL_PADDING (char_1*)"2"
#define SPEC_DEFAULT_VERTICAL_PADDING (char_1*)"2"
#define SPEC_DEFAULT_FONT (char_1*)"*courier-medium-r-normal-*-8-*"

// define some boolean flags for use with this widget
//
#define SPEC_TRUE 1
#define SPEC_TRUE_STRING (char_1*)"1"
#define SPEC_FALSE 0
#define SPEC_FALSE_STRING (char_1*)"0"
#define SPEC_FFT_MAX 32768.00                   // 2^15 max for signed integers
#define SPEC_FFT_MIN 0.00
#define SPEC_MAX_AMPLITUDE 20.794415417
#define SPEC_MIN_AMPLITUDE 0

// define default structure members
//
#define SPEC_DEFAULT_NUM_CHANS (char_1*)"2"
#define SPEC_DEFAULT_NUM_BYTES (char_1*)"2"
#define SPEC_DEFAULT_DISPLAY_CHAN (char_1*)"0"
#define SPEC_DEFAULT_SAMPLE_FREQ (char_1*)"8000.0"
#define SPEC_DEFAULT_START_TIME (char_1*)"0.0"
#define SPEC_DEFAULT_END_TIME (char_1*)"-1.0"
#define SPEC_DEFAULT_DEBUG (char_1*)"0"
#define SPEC_DEFAULT_MAX_RATE (char_1*)"4000.0"
#define SPEC_DEFAULT_SWAP_BYTES SPEC_FALSE_STRING

// define spec plot specific constants
//
#define SPEC_DEFAULT_WIN_LEN (char_1*)"0.025"
#define SPEC_DEFAULT_FRAME_LEN (char_1*)"0.01"
#define SPEC_DEFAULT_WINDOW (char*)"hamming"
#define SPEC_DEFAULT_PREEMPH (char_1*)"0"
#define SPEC_HAMMING_COEFF (float_4)0.54
#define SPEC_DEFAULT_PREFLAG SPEC_FALSE_STRING
#define SPEC_DEFAULT_FFT_ORDER (char*)"256"
#define SPEC_DEFAULT_CLEAR (char*)"0"
#define SPEC_DEFAULT_BRIGHTNESS (char*)"0.0"
#define SPEC_DEFAULT_CONTRAST (char*)"1.0"
#define SPEC_DEFAULT_AMP_SCALE (char*)"1.0"

// define the default height and width of this widget
//
#define SPEC_DEFAULT_HEIGHT_STR (char_1*)"200"
#define SPEC_DEFAULT_HEIGHT_VAL 200
#define SPEC_DEFAULT_WIDTH_STR (char_1*)"400"
#define SPEC_DEFAULT_WIDTH_VAL 400
#define SPEC_DEFAULT_DEPTH_STR (char_1*)"0"
#define SPEC_DEFAULT_DEPTH_VAL 0

// define the length and separation of the ticks in pixels
//
#define SPEC_DEFAULT_TICK_RES 5
#define SPEC_DEFAULT_MAJOR_TICK 6
#define SPEC_DEFAULT_MINOR_TICK 3

// define the default resolution scaling of the widget plotting
//
#define SPEC_DEFAULT_RES_SCALE (int_4) 2
#define SPEC_INITIAL_MAX_AMP (float_4) 0.0

// define the initial values of the spec plot widget
//
#define SPEC_INIT_X 0.0
#define SPEC_INIT_Y 0.0
#define SPEC_INIT_PADX 0
#define SPEC_INIT_PADY 0
#define SPEC_INIT_WIDTH 0
#define SPEC_INIT_HEIGTH 0
#define SPEC_INIT_DEPTH 0
#define SPEC_INIT_POINTS (XPoint*)NULL
#define SPEC_INIT_NUM_POINTS 0
#define SPEC_INIT_FLAGS 0
#define SPEC_INIT_FILE (char*)NULL
#define SPEC_INIT_NUM_CHAN 0
#define SPEC_INIT_NUM_BYTE 0
#define SPEC_INIT_DISP_CHAN 0
#define SPEC_INIT_START_TIME 0.0
#define SPEC_INIT_END_TIME -1.0
#define SPEC_INIT_DEBUG 0
#define SPEC_INIT_BORDER_WIDTH 0
#define SPEC_INIT_HIGHLIGHT_WIDTH 0
#define SPEC_INIT_SF_D 0.0
#define SPEC_INIT_WINLEN 0.025
#define SPEC_INIT_FRAMELEN 0.010
#define SPEC_INIT_PREEMPH 0
#define SPEC_INIT_PRE_FLAG 0
#define SPEC_INIT_FFT_ORDER 256
#define SPEC_INIT_BRIGHTNESS 0.0
#define SPEC_INIT_CONTRAST 1.0
#define SPEC_INIT_FFT_MIN -FLT_MIN
#define SPEC_INIT_FFT_MAX FLT_MIN
#define SPEC_INIT_FFT_DATA (double*)NULL
#define SPEC_INIT_MAX_RATE 0.0
#define SPEC_INIT_NUM_COLORS 256
#define SPEC_INIT_GIMAGE (XImage*)NULL

// set the minimum number of args to the widget
//
#define SPEC_MINIMUM_NUM_ARGS 2

// set the number of vertices in a polygon which describes this item
// in this case it is a rectangle
//
#define SPEC_POLY_VERTICES 4

// set flag constants
//
#define SPEC_REDRAW_NEEDED 0x1

// define minimum log spec value we will plot
//
#define SPEC_MIN_VALUE (double)1.0
  
// end of file
//
#endif



