// file: spec_scal_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_scale_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the spec_plot widget
//     double origin_x: x point of origin
//     double origin_y: y point of origin
//     double scale_x: amount to scale in x direction
//     double scale_y: amount to scale in y direction
//
// returns: int
//
// this function rescales this widget
//
void spec_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			 double origin_y, double scale_x, double scale_y) {

  // cast the item pointer to the widget type
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;

  // set the new x and y coordinates of this widget
  // 
  spec_plot->x = origin_x + scale_x*(spec_plot->x - origin_x);
  spec_plot->y = origin_y + scale_y*(spec_plot->y - origin_y);  

  // get the distance
  //
  spec_plot_bbox_cc(spec_plot->interpreter, canvas, spec_plot);

  // return the value
  //
  return;

}
  





