// file: spec_pnt_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_to_point_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the spec_plot widget
//     double* point_ptr: pointer to x and y coords to be tested
//
// returns: double
//
// this function computes the distance from a given point to this item
// in canvas units
//
double spec_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			       double* point_ptr) {

  // declare local variables
  //
  double distance;
  
  // cast the item pointer to the widget type
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;

  // get the distance
  //
  distance = TkPolygonToPoint(spec_plot->coord_ptr, SPEC_POLY_VERTICES,
			      point_ptr);

  // return the value
  //
  return distance;

}
  





