// file: spec_filt_0.cc
//
// preemphasizes the data using a standard pre-emphasis filter
//

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "spectrogram_plot.h"
#include "spectrogram_plot_constants.h"

// function: spec_pre_emphasize_data_cc
//
// arguments:
//
//  double* data: (input/output) sampled data
//  double coeff: (input) filter coefficient
//  long num_samples: (input) number of samples in the data stream
//  
// return value: a logical indicating status
//
// this function pre-emphasizes the input data using the filter:
//
//   1 - (a * z^(-1)).
//
// the input data is overwritten
//

logical_1 spec_pre_emphasize_data_cc(double* data_a, double coeff_a,
				long num_samples_a) {


  // check for null data
  //
  if (data_a == (double*)NULL) {
    return ISIP_FALSE;
  }
  
  // loop over all data
  //
  for (long samp_num = num_samples_a - 1; samp_num > 0; samp_num--) {
    
    // compute and store the pre-emphasized x(n) value
    //
    data_a[samp_num] = data_a[samp_num] - (coeff_a * data_a[samp_num - 1]);    
  }
  data_a[0] = data_a[0]*(1-coeff_a);
  
  // exit gracefully
  //
  return ISIP_TRUE;
}





