// file: spec_fft_0.cc
//

// isip include files
//
#include "spectrogram_plot.h"

#include "spectrogram_plot_constants.h"

#include <fourier_transform.h>
#include <fourier_transform_constants.h>

// method: compute_fft_cc
//
// arguments:
//  double* output_a: (output) FT transform magnitude coefficients
//  double* input_a: (input) real time domain signal data
//  long num_samples_a: (input) order of the fft. this must be the same as
//                      the size of both input_a and output_a
//
// this method returns the fft magnitude spectrum
//
logical compute_fft_cc(double* output_a, double* input_a,
		       long fft_order_a, double amplitude_scale_factor) {

  Fourier_transform ft;

  double freq[fft_order_a * 2];
  
  ft.set_cc(fft_order_a, FT_RAD2, FT_REAL);

  ft.compute_cc(freq, input_a);

  for (long i = 1; i < fft_order_a; i++) {
    double real = freq[2 * i];
    double imag = freq[2 * i + 1];
    output_a[i] = sqrt(real * real + imag * imag) * amplitude_scale_factor;
  }
  output_a[0] = freq[0];
  
  // return without error
  //
  return ISIP_TRUE;
}
