// file: spec_disp_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_display_cc
//
// parameters:
//     Tk_Canvas canvas: canvas this widget resides in
//     Tk_Item* item_ptr: this item
//     Display* display: display being used
//     Drawable drawable: x object to draw into
//     int x, y, width, height: describe the area to be redisplayed on the
//                              canvas. this *is not* necessarily the same
//                              area that our object resides in which is why
//                              we don't use them here.
//
// returns: int indicating status
//
// this function displays the spec_plot widget
//
void spec_plot_display_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			  Display* display, Drawable drawable, int x, int y,
			  int width, int height) {

  // declare screen offsets for this item
  //
  int x_offset, y_offset;
  short x_left = 0;
  short x_right = 0;
  short y_top = 0;
  short y_bottom = 0;
  
  // cast the item pointer to the widget type
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;

  // declare a pointer to a structure containing values for the graphics
  // context
  //
  XGCValues gc_values;
  
  // find the offsets for the plot. spec_plot->coord_ptr has the four vertices
  // of the rectangle we are using in clockwise order. That is why we access
  // array locations 0, 1, 4, 5
  //
  if (spec_plot->coord_ptr != NULL) {
    Tk_CanvasDrawableCoords(canvas, spec_plot->coord_ptr[0],
			    spec_plot->coord_ptr[1], &x_left, &y_top);
    Tk_CanvasDrawableCoords(canvas, spec_plot->coord_ptr[4],
			    spec_plot->coord_ptr[5], &x_right, &y_bottom);
  }

  // declare the width and height of the region to draw
  //
  int area_width = (int)(x_right-x_left);
  int area_height = (int)(y_bottom - y_top);
  
  // set the offsets to include the borderwidths, etc.
  //
  x_offset = x_left + spec_plot->border_width;
  y_offset = y_top + spec_plot->border_width;
  
  if (spec_plot->flags & SPEC_REDRAW_NEEDED) {
    
    // set up the Gimage map
    //
    if (spec_plot->Gimage != NULL) {

      XDestroyImage(spec_plot->Gimage);
      spec_plot->Gimage = (XImage*)NULL;
    }
    
    // allocate memory for the image map
    //
    Tk_Window w = Tk_CanvasTkwin(canvas);
    char* d = NULL;
    int len;
    spec_plot->depth = Tk_Depth(w);
    
    if (spec_plot->depth >= 24) {
      len = (spec_plot->width + 3) * spec_plot->height * spec_plot->depth / 6;
    } else {
      len = (spec_plot->width + 3) * spec_plot->height * spec_plot->depth / 8;
    }
    d = (char*)ckalloc(len);
    spec_plot->Gimage = XCreateImage(display, Tk_Visual(w), spec_plot->depth,
				    ZPixmap, 0, d, spec_plot->width,
				    spec_plot->height, 32, 0);
    
    // get the current relief type
    //
    if (strcmp(Tk_NameOfRelief(spec_plot->relief),
	       (char*)SPEC_RELIEF_ERROR_NAME) == 0) {
      spec_plot->relief = SPEC_DEFAULT_RELIEF;
    }
    
    // setup the graphics context values
    //
    gc_values.graphics_exposures = False;
    gc_values.background = Tk_3DBorderColor(spec_plot->background)->pixel;
    gc_values.foreground = spec_plot->foreground->pixel;
    
    // generate the graphics context for this widget
    //
    if (spec_plot->text_gc == None) {
      spec_plot->text_gc = Tk_GetGC(Tk_CanvasTkwin(canvas),
				   (GCBackground | GCForeground |
				    GCGraphicsExposures),
				   &gc_values);
    }
    
    // draw a rectangle around the widget
    //
    Tk_Draw3DRectangle(Tk_CanvasTkwin(canvas), drawable, spec_plot->background,
		       x_left, y_top, area_width, area_height,
		       spec_plot->border_width, spec_plot->relief);

    // compute the spectrogram data
    //
    if (spec_plot_compute_spectrogram_cc(spec_plot, area_width -
					 2 * spec_plot->border_width)
	== TCL_ERROR) {

      // if an error returns then free memory and return
      //
      return;
    }

    // determine the x coord of the image
    //
    int_4 xcoord = 0;
    if (x < spec_plot->header.x1) {
      xcoord = 0;
    }
    else {
      xcoord = x - spec_plot->header.x1;
    }

    // call the function to create the line segments
    //
    if (spec_plot_draw_spectrogram_cc(spec_plot, display, drawable,
				      area_width - 2*spec_plot->border_width,
				      area_height -2*spec_plot->border_width,
				      x_offset, y_offset, xcoord, width) ==
	TCL_ERROR) {
      
      // if an error occurs, free memory and return
      //
      return;
    }
    
    // copy the drawable to an offscreen pixmap
    //
    XPutImage(display, drawable, spec_plot->text_gc, spec_plot->Gimage,
	      0, 0, x_left, y_top, width, area_height);
    
    // cancel the redraws if anything was drawn to begin with
    //
    if (spec_plot->num_fft_d > 0) {
      spec_plot->flags = spec_plot->flags & (~SPEC_REDRAW_NEEDED);
    }
  }
  else {
    
    // copy the pixmap onto the drawing area to be updated
    //
    XPutImage(display, drawable, spec_plot->text_gc, spec_plot->Gimage,
	      0, 0, x_left, y_top, area_width, area_height);
  }
  
  // exit gracefully
  //
}














