// file: spec_dest_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_destroy_cc
//
// parameters:
//     Tk_Canvas canvas: the canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the spec_plot widget
//     Display* display: display containing window for the canvas
//
// returns: int indicating status
//
// this function frees the resources used by the spec_plot widget
//
void spec_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display) {

  // cast the client_data to a spec plot object
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;

  // free up the graphic resources
  //
  // free the highlight graphics context
  //
  if (spec_plot->highlight_gc != None) {
    Tk_FreeGC(display, spec_plot->highlight_gc);
  }

  // free the text graphics context
  //
  if (spec_plot->text_gc != None) {
    Tk_FreeGC(display, spec_plot->text_gc);
  }

  // free memory for the coord pointer
  //
  if (spec_plot->coord_ptr != NULL) {
    Tcl_Free((char*)spec_plot->coord_ptr);
  }

  // free memory for pixmap
  //
  if (spec_plot->Gimage != (XImage*)NULL) {
    XDestroyImage(spec_plot->Gimage);
    spec_plot->Gimage = (XImage*)NULL;
  }

  // exit gracefully
  //
}

