// file: spec_cmd_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_cmd_cc
//
// parameters:
//     Tcl_Interp* interpreter: a tcl interpreter object
//     Tk_Canvas canvas: canvas to hold the new item
//     Tk_Item* item_ptr: record to hold the new item, the header has been
//                        initialized by the caller
//     int argc: number of arguments for this widget
//     Tcl_Obj* const* argv: arguments for this widget
//
// returns: int indicating status
//
// this function initializes the spec plot widget
//
int spec_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		       Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv) {

  // cast the item pointer to the proper type for this widget
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;

  // check the number of arguments (if this is used directly from tcl)
  //
  if (argc < 0) {
    Tcl_AppendResult(interpreter, "wrong # args: should be\"",
		     Tk_PathName(Tk_CanvasTkwin(canvas)), "create",
		     item_ptr->typePtr->name, "?options?\"",
		     (char*) NULL);
    return TCL_ERROR;
  }
  
  // allocate and initialize the widget record
  //
  spec_plot->interpreter = interpreter;
  spec_plot->canvas = canvas;
  spec_plot->x = SPEC_INIT_X;
  spec_plot->y = SPEC_INIT_Y;
  spec_plot->width = SPEC_INIT_WIDTH;
  spec_plot->height = SPEC_INIT_HEIGTH;
  spec_plot->coord_ptr =
    (double*) Tcl_Alloc(2*SPEC_POLY_VERTICES*sizeof(double));
  spec_plot->border_width = SPEC_INIT_BORDER_WIDTH;
  spec_plot->relief = TK_RELIEF_FLAT;
  spec_plot->background = (Tk_3DBorder)NULL;
  spec_plot->foreground = (XColor*)NULL;
  spec_plot->highlight = (XColor*)NULL;
  spec_plot->highlight_bg = (XColor*)NULL;
  spec_plot->highlight_gc = None;
  spec_plot->text_gc = None;
  spec_plot->highlight_width = SPEC_INIT_HIGHLIGHT_WIDTH;
  spec_plot->padX = SPEC_INIT_PADX;
  spec_plot->padY = SPEC_INIT_PADY;
  spec_plot->flags = SPEC_INIT_FLAGS;
  spec_plot->font = (char*)SPEC_DEFAULT_FONT;  
  spec_plot->file_name_d = SPEC_INIT_FILE;
  spec_plot->num_chans_d = SPEC_INIT_NUM_CHAN;
  spec_plot->num_bytes_d = SPEC_INIT_NUM_BYTE;
  spec_plot->display_channel_d = SPEC_INIT_DISP_CHAN;
  spec_plot->sf_d = SPEC_INIT_SF_D;
  spec_plot->swap_byte_flag_d = SPEC_FALSE;  
  spec_plot->start_time_d = SPEC_INIT_START_TIME;  
  spec_plot->end_time_d = SPEC_INIT_END_TIME;
  spec_plot->debug_level_d = SPEC_INIT_DEBUG;
  spec_plot->fft_len_d = (int_4)SPEC_INIT_FFT_ORDER;
  spec_plot->num_fft_d = (int_4)0;
  spec_plot->win_length_d = SPEC_INIT_WINLEN;
  spec_plot->frame_length_d = SPEC_INIT_FRAMELEN;
  spec_plot->pre_emph_coeff_d = SPEC_INIT_PREEMPH;
  spec_plot->pre_emph_flag_d = SPEC_INIT_PRE_FLAG;
  spec_plot->fft_max_d = SPEC_INIT_FFT_MAX;
  spec_plot->fft_min_d = SPEC_INIT_FFT_MIN;
  spec_plot->Gimage = SPEC_INIT_GIMAGE;
  spec_plot->max_freq_d = SPEC_INIT_MAX_RATE;
  spec_plot->num_colors_d = SPEC_INIT_NUM_COLORS;
  spec_plot->fft_data_d = SPEC_INIT_FFT_DATA;
  spec_plot->contrast_d = SPEC_INIT_CONTRAST;
  spec_plot->brightness_d = SPEC_INIT_BRIGHTNESS;
  spec_plot->window_option_d = SPEC_DEFAULT_WINDOW;


  // define the spectrogram color map
  //
  spec_plot->colormap_d = new XColor*[116];
  spec_plot->num_colors_d = 116;
  XColor xcolorPref;
  xcolorPref.flags = DoRed | DoGreen | DoBlue;

  // set the default background color
  //
  int_4 i = 0;
  xcolorPref.red = 8448;
  xcolorPref.green = 19200;
  xcolorPref.blue =  33410;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);

  // set the rest of the colors.
  //
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 44975;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 43433;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 41891;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 40349;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 38807;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 37265;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 35723;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 34181;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 31097;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 29555;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 28013;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 26471;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 24929;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 23387;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 21845;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 20303;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 17219;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 15677;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 14135;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 12593;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 11051;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 9509;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 7967;
  xcolorPref.blue = 44975;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 0;
  xcolorPref.green = 0;
  xcolorPref.blue = 32896;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 1028;
  xcolorPref.green = 0;
  xcolorPref.blue = 31868;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 1542;
  xcolorPref.green = 0;
  xcolorPref.blue = 31354;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 2056;
  xcolorPref.green = 0;
  xcolorPref.blue = 30840;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 2570;
  xcolorPref.green = 0;
  xcolorPref.blue = 30326;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 3084;
  xcolorPref.green = 0;
  xcolorPref.blue = 29812;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 3598;
  xcolorPref.green = 0;
  xcolorPref.blue = 29298;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 4112;
  xcolorPref.green = 0;
  xcolorPref.blue = 28784;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 4626;
  xcolorPref.green = 0;
  xcolorPref.blue = 28270;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 5654;
  xcolorPref.green = 0;
  xcolorPref.blue = 27242;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 6168;
  xcolorPref.green = 0;
  xcolorPref.blue = 26728;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 6682;
  xcolorPref.green = 0;
  xcolorPref.blue = 26214;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 7196;
  xcolorPref.green = 0;
  xcolorPref.blue = 25700;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 7710;
  xcolorPref.green = 0;
  xcolorPref.blue = 25186;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 8224;
  xcolorPref.green = 0;
  xcolorPref.blue = 24672;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 8738;
  xcolorPref.green = 0;
  xcolorPref.blue = 24158;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 9252;
  xcolorPref.green = 0;
  xcolorPref.blue = 23644;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 10280;
  xcolorPref.green = 0;
  xcolorPref.blue = 22616;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 10794;
  xcolorPref.green = 0;
  xcolorPref.blue = 22102;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 11308;
  xcolorPref.green = 0;
  xcolorPref.blue = 21588;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 11822;
  xcolorPref.green = 0;
  xcolorPref.blue = 21074;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 12336;
  xcolorPref.green = 0;
  xcolorPref.blue = 20560;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 16448;
  xcolorPref.green = 0;
  xcolorPref.blue = 20046;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 17990;
  xcolorPref.green = 0;
  xcolorPref.blue = 19532;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 19532;
  xcolorPref.green = 0;
  xcolorPref.blue = 19018;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 22616;
  xcolorPref.green = 0;
  xcolorPref.blue = 17990;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 24158;
  xcolorPref.green = 0;
  xcolorPref.blue = 17476;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 25700;
  xcolorPref.green = 0;
  xcolorPref.blue = 16962;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 27242;
  xcolorPref.green = 0;
  xcolorPref.blue = 16448;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 28784;
  xcolorPref.green = 0;
  xcolorPref.blue = 15934;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 30326;
  xcolorPref.green = 0;
  xcolorPref.blue = 15420;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 31868;
  xcolorPref.green = 0;
  xcolorPref.blue = 14906;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 33410;
  xcolorPref.green = 0;
  xcolorPref.blue = 14392;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 36494;
  xcolorPref.green = 0;
  xcolorPref.blue = 13364;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 38036;
  xcolorPref.green = 0;
  xcolorPref.blue = 12850;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 39578;
  xcolorPref.green = 0;
  xcolorPref.blue = 12336;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 41120;
  xcolorPref.green = 0;
  xcolorPref.blue = 11822;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 42662;
  xcolorPref.green = 0;
  xcolorPref.blue = 11308;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 44204;
  xcolorPref.green = 0;
  xcolorPref.blue = 10794;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 45746;
  xcolorPref.green = 0;
  xcolorPref.blue = 10280;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 47288;
  xcolorPref.green = 0;
  xcolorPref.blue = 9766;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 50372;
  xcolorPref.green = 0;
  xcolorPref.blue = 8738;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 51914;
  xcolorPref.green = 0;
  xcolorPref.blue = 8224;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 53456;
  xcolorPref.green = 0;
  xcolorPref.blue = 7710;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 0;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 2570;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 5140;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 7710;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 10280;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 15420;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 17990;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 20560;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 23130;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 25700;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 28270;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 30840;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 33410;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 38550;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 41120;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 43690;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 46260;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 48830;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 51400;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 53970;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 56540;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 61680;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 0;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 2056;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 4112;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 6168;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 8224;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 10280;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 12336;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 16448;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 18504;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 20560;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 22616;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 24672;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 26728;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 28784;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 30840;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 34952;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 37008;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 39064;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 41120;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 43176;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 45232;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 47288;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 49344;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 53456;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 55512;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  i++;
  xcolorPref.red = 65535;
  xcolorPref.green = 65535;
  xcolorPref.blue = 65535;
  spec_plot->colormap_d[i] = Tk_GetColorByValue(Tk_MainWindow(interpreter), &xcolorPref);
  
  
  // parse the command line arguments
  //
  if (spec_plot_config_cc(interpreter, canvas, item_ptr,
			  argc-SPEC_MINIMUM_NUM_ARGS,
			  argv+SPEC_MINIMUM_NUM_ARGS, 0) != TCL_OK) {
    spec_plot_destroy_cc(canvas, item_ptr,
			 Tk_Display(Tk_CanvasTkwin(canvas)));
    return TCL_ERROR;
  }
  
  // get the upper left hand corner point of this item on the canvas
  // the height and width should be specified through the configure options
  //
  char x_loc[ISIP_MAX_STRING_LENGTH];
  char y_loc[ISIP_MAX_STRING_LENGTH];
  sprintf(x_loc, "%d", spec_plot->x_loc);
  sprintf(y_loc, "%d", spec_plot->y_loc);  
  if ((Tk_CanvasGetCoord(interpreter, canvas, x_loc, &spec_plot->x)
       != TCL_OK) || (Tk_CanvasGetCoord(interpreter, canvas, y_loc,
					&spec_plot->y) != TCL_OK)) {
    return TCL_ERROR;
  }
  
  // exit gracefully
  //
  return TCL_OK;

}






