// file: spec_cfg_0.cc
//

// isip include files
//
#ifndef __ISIP_SPEC_PLOT
#include "spectrogram_plot.h"
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// function: spec_plot_config_cc
//
// parameters:
//     Tcl_Interp* interp: a tcl interpreter object
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the spec_plot widget
//     int objc: number of arguments for this widget
//     Tcl_Obj* const* objv: arguments for this widget
//     int flags: status flags (not in use right now)
//
// returns: int indicating status
//
// this function configures the spec plot widget
//
int spec_plot_config_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Tk_Item* item_ptr, int objc, Tcl_Obj* const* objv,
			int flags) {

  // declare an array of character pointers
  //
  char** argv;
  
  // cast the item pointer to the widget type
  //
  Spec_plot_item* spec_plot = (Spec_plot_item*) item_ptr;
  
  // allocate memory for the output items
  //
  char x[TCL_DOUBLE_SPACE], y[TCL_DOUBLE_SPACE];
  
  // set a pointer to the canvas
  //
  Tk_Window tkwin = Tk_CanvasTkwin(canvas);

  // call the tk configure method to configure the widget and check for
  // errors
  //
  argv = (char**)calloc(objc, sizeof(char*));
  for (int i=0; i < objc; i++) {
    argv[i] = Tcl_GetString(objv[i]);
  }
  if (Tk_ConfigureWidget(interpreter, tkwin, spec_plot_config_specs, objc,
			 argv, (char*)spec_plot, flags) != TCL_OK) {
    return TCL_ERROR;
  }
  free(argv);
  
  // compute the bounding box for the widget
  //
  spec_plot_bbox_cc(interpreter, canvas, spec_plot);

  // reset the x and y for this widget
  //
  sprintf(x, "%d", spec_plot->x_loc);
  sprintf(y, "%d", spec_plot->y_loc);  
  Tk_CanvasGetCoord(interpreter, canvas, x, &spec_plot->x);
  Tk_CanvasGetCoord(interpreter, canvas, y, &spec_plot->y);  
  
  // set the redraw flag to let the widget know that the canvas does need to
  // be updated
  //
  spec_plot->flags = spec_plot->flags | SPEC_REDRAW_NEEDED;
   
  // exit gracefully
  //
  return TCL_OK;
}







