// file: sigpl_scal_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_scale_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the signal_plot widget
//     double origin_x: x point of origin
//     double origin_y: y point of origin
//     double scale_x: amount to scale in x direction
//     double scale_y: amount to scale in y direction
//
// returns: int
//
// this function rescales this widget
//
void signal_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			 double origin_y, double scale_x, double scale_y) {

  // cast the item pointer to the widget type
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;

  // set the new x and y coordinates of this widget
  // 
  sig_plot->x = origin_x + scale_x*(sig_plot->x - origin_x);
  sig_plot->y = origin_y + scale_y*(sig_plot->y - origin_y);  

  // get the distance
  //
  signal_plot_bbox_cc(sig_plot->interpreter, canvas, sig_plot);

  // return the value
  //
  return;

}
  





