// file: sigpl_pnt_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_to_point_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the signal_plot widget
//     double* point_ptr: pointer to x and y coords to be tested
//
// returns: double
//
// this function computes the distance from a given point to this item
// in canvas units
//
double signal_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			       double* point_ptr) {

  // declare local variables
  //
  double distance;
  
  // cast the item pointer to the widget type
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;

  // get the distance
  //
  distance = TkPolygonToPoint(sig_plot->coord_ptr, SIGPLOT_POLY_VERTICES,
			      point_ptr);

  // return the value
  //
  return distance;

}
  





