// file: sigpl_tick_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_tick_cc
//
// parameters:
//     Signal_plot_item* sig_plot: this widget
//     Display* display: X display handle for this widget item
//     Drawable drawable: x object to draw into
//     int area_width:  width of the area to draw to
//     int area_height: height of the area to draw to
//     int x_offset: virtual upper-left x coordinate
//     int y_offset: virtual upper-left y coordinate
//
// returns: int indicating status
//
// this function displays the signal_plot widget tick marks
//
int signal_plot_plot_ticks_cc(Signal_plot_item* sig_plot, Display* display,
			      Drawable drawable, int area_width,
			      int area_height, int x_offset, int y_offset) {

  // declare screen offsets for this item
  //
  int y_zero = (y_offset + (y_offset + area_height)) >> 1;
  
  // draw the major and minor tick marks on the left and right of the drawing
  // area
  //
  int y_pos = y_zero;
  int x_right = x_offset + area_width;
  for (;  y_pos >= y_offset;) {
    XDrawLine(display, drawable, sig_plot->text_gc, x_offset, y_pos,
	      x_offset+SIGPLOT_DEFAULT_MAJOR_TICK, y_pos);
    XDrawLine(display, drawable, sig_plot->text_gc, x_right, y_pos,
	      x_right-SIGPLOT_DEFAULT_MAJOR_TICK, y_pos);    
    int y_symm = ((y_zero - y_pos) +  y_zero);
    XDrawLine(display, drawable, sig_plot->text_gc, x_offset,
	      y_symm, x_offset+SIGPLOT_DEFAULT_MAJOR_TICK, y_symm);
    XDrawLine(display, drawable, sig_plot->text_gc, x_right,
	      y_symm, x_right-SIGPLOT_DEFAULT_MAJOR_TICK, y_symm);

    // draw the minor tick lines
    //
    int i;
    for (i = 0, y_pos -= SIGPLOT_DEFAULT_TICK_RES;
	 ((i < 4) && (y_pos >= y_offset)); y_pos -= SIGPLOT_DEFAULT_TICK_RES,
	   i++) {
	   XDrawLine(display, drawable, sig_plot->text_gc, x_offset, y_pos,
		     x_offset+SIGPLOT_DEFAULT_MINOR_TICK, y_pos);
	   XDrawLine(display, drawable, sig_plot->text_gc, x_right, y_pos,
		     x_right-SIGPLOT_DEFAULT_MINOR_TICK, y_pos);
	   int y_symm = ((y_zero - y_pos) +  y_zero);
	   XDrawLine(display, drawable, sig_plot->text_gc, x_offset,
		     y_symm, x_offset+SIGPLOT_DEFAULT_MINOR_TICK, y_symm);
	   XDrawLine(display, drawable, sig_plot->text_gc, x_right,
		     y_symm, x_right-SIGPLOT_DEFAULT_MINOR_TICK, y_symm);	   
    }
  }
  
  // draw the major and minor tick marks on the top and bottom of the drawing
  // area
  //
  int x_pos = x_offset;
  int y_bottom = y_offset + area_height;
  for (;  x_pos <= x_right;) {
    XDrawLine(display, drawable, sig_plot->text_gc,  x_pos, y_offset,
	      x_pos, y_offset+SIGPLOT_DEFAULT_MAJOR_TICK);
    XDrawLine(display, drawable, sig_plot->text_gc,  x_pos, y_bottom,
	      x_pos, y_bottom-SIGPLOT_DEFAULT_MAJOR_TICK);    

    // draw the minor tick lines
    //
    int i;
    for (i = 0, x_pos += SIGPLOT_DEFAULT_TICK_RES;
	 ((i < 4) && (x_pos <= x_right)); x_pos += SIGPLOT_DEFAULT_TICK_RES,
	   i++) {
	   XDrawLine(display, drawable, sig_plot->text_gc,  x_pos, y_offset,
		     x_pos, y_offset+SIGPLOT_DEFAULT_MINOR_TICK);
	   XDrawLine(display, drawable, sig_plot->text_gc,  x_pos, y_bottom,
		     x_pos, y_bottom-SIGPLOT_DEFAULT_MINOR_TICK);
    }
  }
  
  // exit gracefully
  //
  return TCL_OK;  
}

