// file: sigpl_disp_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_display_cc
//
// parameters:
//     Tk_Canvas canvas: canvas this widget resides in
//     Tk_Item* item_ptr: this item
//     Display* display: display being used
//     Drawable drawable: x object to draw into
//     int x, y, width, height: describe the area to be redisplayed on the
//                              canvas. this *is not* necessarily the same
//                              area that our object resides in which is why
//                              we don't use them here.
//
// returns: int indicating status
//
// this function displays the signal_plot widget
//
void signal_plot_display_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display, Drawable drawable, int x, int y,
			    int width, int height) {

  // declare screen offsets for this item
  //
  int x_offset, y_offset;
  short x_left = 0;
  short x_right = 0;
  short y_top = 0;
  short y_bottom = 0;
  
  // cast the item pointer to the widget type
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;
  
  // declare a pointer to a structure containing values for the graphics
  // context
  //
  XGCValues gc_values;

    
  // find the offsets for the plot. sig_plot->coord_ptr has the four vertices
  // of the rectangle we are using in clockwise order. That is why we access
  // array locations 0, 1, 4, 5
  //
  if (sig_plot->coord_ptr != NULL) {
    Tk_CanvasDrawableCoords(canvas, sig_plot->coord_ptr[0],
			    sig_plot->coord_ptr[1], &x_left, &y_top);
    Tk_CanvasDrawableCoords(canvas, sig_plot->coord_ptr[4],
			    sig_plot->coord_ptr[5], &x_right, &y_bottom);
  }
    
  // declare the width and height of the region to draw
  //
  int area_width = (int)(x_right-x_left);
  int area_height = (int)(y_bottom - y_top);
    
  // set the offsets to include the borderwidths, etc.
  //
  x_offset = x_left + sig_plot->border_width;
  y_offset = y_top + sig_plot->border_width;
    
  // make sure that an update needs to be done
  // 
  if (sig_plot->flags & SIGPLOT_REDRAW_NEEDED) {

    // free the old plotted points
    //
    if (sig_plot->plotted_points != NULL) {
      Tcl_Free((char*) sig_plot->plotted_points);
      sig_plot->plotted_points = NULL;
    }
    
    // create a new pixmap, making sure there is not already an
    // existent one
    //
    if (sig_plot->pixmap != None) {
      Tk_FreePixmap(display, sig_plot->pixmap);
    }
    sig_plot->pixmap = Tk_GetPixmap(display,
				    Tk_WindowId(Tk_CanvasTkwin(canvas)),
				    area_width, area_height,
				    Tk_Depth(Tk_CanvasTkwin(canvas)));
    
    // get the current relief type
    //
    if (strcmp(Tk_NameOfRelief(sig_plot->relief),
	       (char*)SIGPLOT_RELIEF_ERROR_NAME) == 0) {
      sig_plot->relief = SIGPLOT_DEFAULT_RELIEF;
    }
    
    // setup the graphics context values
    //
    gc_values.graphics_exposures = False;
    gc_values.background = Tk_3DBorderColor(sig_plot->background)->pixel;
    gc_values.foreground = sig_plot->foreground->pixel;
    
    // generate the graphics context for this widget
    //
    if (sig_plot->text_gc == None) {
      sig_plot->text_gc = Tk_GetGC(Tk_CanvasTkwin(canvas),
				   (GCBackground | GCForeground |
				   GCGraphicsExposures),
				   &gc_values);
    }
    
    // draw a rectangle around the widget
    //
    Tk_Draw3DRectangle(Tk_CanvasTkwin(canvas), drawable, sig_plot->background,
		       x_left, y_top, area_width, area_height,
		       sig_plot->border_width, sig_plot->relief);
    
    // determine the tick mark locations and plot them to the drawable
    //
    //    if (signal_plot_plot_ticks_cc(sig_plot, display, drawable,
    //				  area_width - (2 * sig_plot->border_width),
    //				  area_height - (2 * sig_plot->border_width),
    //				  x_offset, y_offset) ==
    //	TCL_ERROR) {
    //
    //      // return if an error occurs
    //      //
    //      return;
    //    }
    
    // call the function to create the line segments
    //
    if (signal_plot_plot_points_cc(sig_plot, sig_plot->num_points,
				   &sig_plot->plotted_points,
				   area_width - 2*sig_plot->border_width,
				   area_height - 2*sig_plot->border_width,
				   x_offset, y_offset, display, drawable) ==
	TCL_ERROR) {
      
      // if an error occurs, free memory and return
      //
      return;
    }
    
    // copy the drawable to an offscreen pixmap
    //
    XCopyArea(display, drawable, sig_plot->pixmap, sig_plot->text_gc,
	      x_left, y_top, area_width, area_height, 0, 0);
    
    // cancel the redraws if anything was drawn to begin with
    // this explicit check makes sure that this is not the startup
    // case where no points are drawn
    //
    if (sig_plot->num_points > 0) {
      sig_plot->flags = sig_plot->flags & (~SIGPLOT_REDRAW_NEEDED);
    }
  }
  else {

    // copy the pixmap onto the drawing area to be updated
    //
    XCopyArea(display, sig_plot->pixmap, drawable, sig_plot->text_gc,
	      0, 0, area_width, area_height, x_left, y_top);
  }
  
  // exit gracefully
  //
}

