// file: sigpl_dest_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_destroy_cc
//
// parameters:
//     Tk_Canvas canvas: the canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the signal_plot widget
//     Display* display: display containing window for the canvas
//
// returns: int indicating status
//
// this function frees the resources used by the signal_plot widget
//
void signal_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display) {

  // cast the client_data to a signal plot object
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;

  // free up the graphic resources
  //
  // free the highlight graphics context
  //
  if (sig_plot->highlight_gc != None) {
    Tk_FreeGC(display, sig_plot->highlight_gc);
  }

  // free the text graphics context
  //
  if (sig_plot->text_gc != None) {
    Tk_FreeGC(display, sig_plot->text_gc);
  }

  // free memory for the coord pointer
  //
  if (sig_plot->coord_ptr != NULL) {
    Tcl_Free((char*)sig_plot->coord_ptr);
  }

  // free memory for the coord pointer
  //
  if (sig_plot->plotted_points != NULL) {
    Tcl_Free((char*)sig_plot->plotted_points);
  }

  // free memory for pixmap
  //
  if (sig_plot->pixmap != None) {
    Tk_FreePixmap(display, sig_plot->pixmap);
    sig_plot->pixmap = None;
  }

  // exit gracefully
  //
}

