// file: sigpl_coord_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_coord_cc
//
// parameters:
//     Tcl_Interp* interp: a tcl interpreter object
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: signal plot widget
//     int argc: number of arguments for this widget
//     Tcl_Obj* CONST argv: arguments for this widget
//
// returns: int indicating status
//
// this function processes the coords widget command. the coords command
// queries or sets the current coordinates for this widget
//
int signal_plot_coords_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			  Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv) {

  // cast the item pointer to the proper type for this widget
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;
  
  // allocate memory for the output items
  //
  char x[TCL_DOUBLE_SPACE], y[TCL_DOUBLE_SPACE];
  
  // if no arguments then return the coordinates of this object in the
  // interpreter result buffer
  //
  if (argc == 0) {
    Tcl_PrintDouble(interpreter, sig_plot->x, x);
    Tcl_PrintDouble(interpreter, sig_plot->y, y);
    Tcl_AppendResult(interpreter, x, " ", y, (char *) NULL);
  }
  else if (argc == SIGPLOT_MINIMUM_NUM_ARGS) {
    
    // get the new x and y coords for this item
    //
    sig_plot->x_loc = atoi(Tcl_GetString(argv[0]));
    sig_plot->y_loc = atoi(Tcl_GetString(argv[1]));    
    if ((Tk_CanvasGetCoord(interpreter, canvas,
			   Tcl_GetString(argv[0]),
			   &sig_plot->x) != TCL_OK) ||
	(Tk_CanvasGetCoord(interpreter, canvas,
			   Tcl_GetString(argv[1]),
			   &sig_plot->y) != TCL_OK)) {
      return TCL_ERROR;
    }
  }
  else {
    
    // wrong number of arguments, return error
    //
    Tcl_AppendResult(interpreter, "wrong # coordinates", (char*) NULL);
    return TCL_ERROR;
  }
    
  // compute the bounding box for the item
  //
  signal_plot_bbox_cc(interpreter, canvas, sig_plot);
  
  // exit gracefully
  //
  return TCL_OK;

}
