// file: sigpl_cmd_0.cc
//

// isip include files
//
#ifndef __ISIP_SIGNAL_PLOT
#include "signal_plot.h"
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// function: signal_plot_cmd_cc
//
// parameters:
//     Tcl_Interp* interpreter: a tcl interpreter object
//     Tk_Canvas canvas: canvas to hold the new item
//     Tk_Item* item_ptr: record to hold the new item, the header has been
//                        initialized by the caller
//     int argc: number of arguments for this widget
//     Tcl_Obj* CONST: arguments for this widget
//
// returns: int indicating status
//
// this function initializes the signal plot widget
//
int signal_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		       Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv) {

  // cast the item pointer to the proper type for this widget
  //
  Signal_plot_item* sig_plot = (Signal_plot_item*) item_ptr;

  // check the number of arguments (if this is used directly from tcl)
  //
  if (argc < 0) {
    Tcl_AppendResult(interpreter, "wrong # args: should be\"",
		     Tk_PathName(Tk_CanvasTkwin(canvas)), "create",
		     item_ptr->typePtr->name, "?options?\"",
		     (char*) NULL);
    return TCL_ERROR;
  }
  
  // allocate and initialize the widget record
  //
  sig_plot->interpreter = interpreter;
  sig_plot->canvas = canvas;
  sig_plot->x = 0.0;
  sig_plot->y = 0.0;
  sig_plot->width = 0;
  sig_plot->height = 0;
  sig_plot->coord_ptr =
    (double*) Tcl_Alloc(2*SIGPLOT_POLY_VERTICES*sizeof(double));
  sig_plot->plotted_points = (XPoint*)NULL;
  sig_plot->num_points = 0;
  sig_plot->pixmap = None;  
  sig_plot->border_width = 0;
  sig_plot->relief = TK_RELIEF_FLAT;
  sig_plot->background = (Tk_3DBorder)NULL;
  sig_plot->foreground = (XColor*)NULL;
  sig_plot->highlight = (XColor*)NULL;
  sig_plot->highlight_bg = (XColor*)NULL;
  sig_plot->highlight_gc = None;
  sig_plot->text_gc = None;
  sig_plot->highlight_width = 0;
  sig_plot->padX = 0;
  sig_plot->padY = 0;
  sig_plot->flags = 0;
  sig_plot->font = (char*)SIGPLOT_DEFAULT_FONT;  
  sig_plot->file_name_d = (char*)NULL;
  sig_plot->num_chans_d = 0;
  sig_plot->num_bytes_d = 0;
  sig_plot->display_channel_d = 0;
  sig_plot->sf_d = 0.0;      
  sig_plot->swap_byte_flag_d = SIGPLOT_FALSE;  
  sig_plot->start_time_d = 0.0;  
  sig_plot->end_time_d = 0.0;
  sig_plot->debug_level_d = 0;
  
  // parse the command line arguments
  //
  if (signal_plot_config_cc(interpreter, canvas, item_ptr,
			    argc-SIGPLOT_MINIMUM_NUM_ARGS,
			    argv+SIGPLOT_MINIMUM_NUM_ARGS, 0) != TCL_OK) {
    signal_plot_destroy_cc(canvas, item_ptr,
			   Tk_Display(Tk_CanvasTkwin(canvas)));
    return TCL_ERROR;
  }

  // get the upper left hand corner point of this item on the canvas
  // the height and width should be specified through the configure options
  //
  char x_loc[ISIP_MAX_STRING_LENGTH];
  char y_loc[ISIP_MAX_STRING_LENGTH];
  sprintf(x_loc, "%d", sig_plot->x_loc);
  sprintf(y_loc, "%d", sig_plot->y_loc);  
  if ((Tk_CanvasGetCoord(interpreter, canvas, x_loc, &sig_plot->x)
       != TCL_OK) || (Tk_CanvasGetCoord(interpreter, canvas, y_loc,
					&sig_plot->y) != TCL_OK)) {
    return TCL_ERROR;
  }
  
  // exit gracefully
  //
  return TCL_OK;

}






