// file: energy_scal_0.cc
//

// isip include files
//
#ifndef __ISIP_ENERGY_PLOT
#include "energy_plot.h"
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// function: energy_plot_scale_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the energy_plot widget
//     double origin_x: x point of origin
//     double origin_y: y point of origin
//     double scale_x: amount to scale in x direction
//     double scale_y: amount to scale in y direction
//
// returns: int
//
// this function rescales this widget
//
void energy_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			 double origin_y, double scale_x, double scale_y) {

  // cast the item pointer to the widget type
  //
  Energy_plot_item* energy_plot = (Energy_plot_item*) item_ptr;

  // set the new x and y coordinates of this widget
  // 
  energy_plot->x = origin_x + scale_x*(energy_plot->x - origin_x);
  energy_plot->y = origin_y + scale_y*(energy_plot->y - origin_y);  

  // get the distance
  //
  energy_plot_bbox_cc(energy_plot->interpreter, canvas, energy_plot);

  // return the value
  //
  return;

}
  





