// file: energy_pnt_0.cc
//

// isip include files
//
#ifndef __ISIP_ENERGY_PLOT
#include "energy_plot.h"
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// function: energy_plot_to_point_cc
//
// parameters:
//     Tk_Canvas canvas: canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the energy_plot widget
//     double* point_ptr: pointer to x and y coords to be tested
//
// returns: double
//
// this function computes the distance from a given point to this item
// in canvas units
//
double energy_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			       double* point_ptr) {

  // declare local variables
  //
  double distance;
  
  // cast the item pointer to the widget type
  //
  Energy_plot_item* energy_plot = (Energy_plot_item*) item_ptr;

  // get the distance
  //
  distance = TkPolygonToPoint(energy_plot->coord_ptr, ENERGY_POLY_VERTICES,
			      point_ptr);

  // return the value
  //
  return distance;

}
  





