// file: energy_plot_constants.h
//

// make sure definitions are made only once
//

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#define __ISIP_ENERGY_PLOT_CONSTANTS
 
// isip include files
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif

// define the class name
//
#define ENERGY_WIDGET_NAME (char_1*)"energy_plot"

// define the configuration string
//
#define ENERGY_CONFIG_STRING (char_1*)"configure"

// define the error string returned from Tk_NameOfRelief
//
#define ENERGY_RELIEF_ERROR_NAME (char_1*)"unknown relief"

// define parameter strings
//
#define ENERGY_AUDIO_FILE_PARAM (char_1*)"-file"
#define ENERGY_NUM_CHANS_PARAM (char_1*)"-num_chans"
#define ENERGY_NUM_BYTES_PARAM (char_1*)"-num_bytes"
#define ENERGY_DISPLAY_CHAN_PARAM (char_1*)"-display_chan"
#define ENERGY_SAMPLE_FREQ_PARAM (char_1*)"-sample_freq"
#define ENERGY_START_TIME_PARAM (char_1*)"-start_time"
#define ENERGY_END_TIME_PARAM (char_1*)"-end_time"
#define ENERGY_GAIN_FACTOR_PARAM (char_1*)"-gain_factor"
#define ENERGY_SWAP_BYTES_PARAM (char_1*)"-swap_bytes"
#define ENERGY_HEIGHT_PARAM (char_1*)"-height"
#define ENERGY_WIDTH_PARAM (char_1*)"-width"
#define ENERGY_X_LOC_PARAM (char_1*)"-x_loc"
#define ENERGY_Y_LOC_PARAM (char_1*)"-y_loc"
#define ENERGY_BORDERWIDTH (char_1*)"-borderwidth"
#define ENERGY_BD (char*)"-bd"
#define ENERGY_PADX (char*)"-padx"
#define ENERGY_PADY (char*)"-pady"
#define ENERGY_FFT_ORDER (char*)"-fft_order"
#define ENERGY_WINLEN (char*)"-winlen"
#define ENERGY_FRAMELEN (char*)"-framelen"
#define ENERGY_PREEMPH (char*)"-preemph_coeff"
#define ENERGY_PREFLAG (char*)"-use_preemph"
#define ENERGY_WIN_OPTION (char*)"-filter"
#define ENERGY_FOREGROUND (char*)"-foreground"
#define ENERGY_FG (char*)"-fg"
#define ENERGY_BACKGROUND (char*)"-background"
#define ENERGY_BG (char*)"-bg"
#define ENERGY_HGLTCOLOR (char*)"-highlightcolor"
#define ENERGY_HGLTBACKGROUND (char*)"-highlightbackground"
#define ENERGY_RELIEF (char*)"-relief"
#define ENERGY_RMS_SCALE_FACTOR (char*)"-rms_scale"
#define ENERGY_AMP_SCALE_FACTOR (char*)"-amp_scale"

// define the default widget characteristics
//
#define ENERGY_DEFAULT_FOREGROUND_COLOR (char_1*)"black"
#define ENERGY_DEFAULT_BACKGROUND_COLOR (char_1*)"white"
#define ENERGY_DEFAULT_HIGHLIGHT_COLOR (char_1*)"red"
#define ENERGY_DEFAULT_BORDERWIDTH (char_1*)"2"
#define ENERGY_DEFAULT_RELIEF_NAME (char_1*)"ridge"
#define ENERGY_DEFAULT_RELIEF TK_RELIEF_RIDGE
#define ENERGY_DEFAULT_HIGHLIGHT_THICKNESS (char_1*)"2"
#define ENERGY_DEFAULT_HORIZONTAL_PADDING (char_1*)"2"
#define ENERGY_DEFAULT_VERTICAL_PADDING (char_1*)"2"
#define ENERGY_DEFAULT_FONT (char_1*)"*courier-medium-r-normal-*-8-*"

// define some boolean flags for use with this widget
//
#define ENERGY_TRUE 1
#define ENERGY_TRUE_STRING (char_1*)"1"
#define ENERGY_FALSE 0
#define ENERGY_FALSE_STRING (char_1*)"0"
#define ENERGY_MAX_AMPLITUDE 9.03
#define ENERGY_MIN_AMPLITUDE 0

// define default structure members
//
#define ENERGY_DEFAULT_NUM_CHANS (char_1*)"2"
#define ENERGY_DEFAULT_NUM_BYTES (char_1*)"2"
#define ENERGY_DEFAULT_DISPLAY_CHAN (char_1*)"0"
#define ENERGY_DEFAULT_SAMPLE_FREQ (char_1*)"8000.0"
#define ENERGY_DEFAULT_START_TIME (char_1*)"0.0"
#define ENERGY_DEFAULT_END_TIME (char_1*)"-1.0"
#define ENERGY_DEFAULT_DEBUG (char_1*)"0"
#define ENERGY_DEFAULT_SWAP_BYTES ENERGY_FALSE_STRING

// define energy plot specific constants
//
#define ENERGY_DEFAULT_FFT_ORDER (char_1*)"256"
#define ENERGY_DEFAULT_WIN_LEN (char_1*)"0.025"
#define ENERGY_DEFAULT_FRAME_LEN (char_1*)"0.01"
#define ENERGY_DEFAULT_PREEMPH (char_1*)"0.97"
#define ENERGY_HAMMING_COEFF (float_4)0.54
#define ENERGY_DEFAULT_PREFLAG ENERGY_FALSE_STRING
#define ENERGY_DEFAULT_WINDOW (char*)"hamming"
#define ENERGY_DEFAULT_SCALE_FACTOR (char*)"1.0"
#define ENERGY_DEFAULT_AMP_SCALE (char*)"1.0"

// define the default height and width of this widget
//
#define ENERGY_DEFAULT_HEIGHT_STR (char_1*)"200"
#define ENERGY_DEFAULT_HEIGHT_VAL 200
#define ENERGY_DEFAULT_WIDTH_STR (char_1*)"400"
#define ENERGY_DEFAULT_WIDTH_VAL 400

// define the length and separation of the ticks in pixels
//
#define ENERGY_DEFAULT_TICK_RES 5
#define ENERGY_DEFAULT_MAJOR_TICK 6
#define ENERGY_DEFAULT_MINOR_TICK 3

// define the default resolution scaling of the widget plotting
//
#define ENERGY_DEFAULT_RES_SCALE (int_4) 2
#define ENERGY_INITIAL_MAX_AMP (float_4) 0.0

// define the initial values of the energy plot widget
//
#define ENERGY_INIT_X 0.0
#define ENERGY_INIT_Y 0.0
#define ENERGY_INIT_PADX 0
#define ENERGY_INIT_PADY 0
#define ENERGY_INIT_WIDTH 0
#define ENERGY_INIT_HEIGTH 0
#define ENERGY_INIT_POINTS (XPoint*)NULL
#define ENERGY_INIT_NUM_POINTS 0
#define ENERGY_INIT_FLAGS 0
#define ENERGY_INIT_FILE (char*)NULL
#define ENERGY_INIT_NUM_CHAN 0
#define ENERGY_INIT_NUM_BYTE 0
#define ENERGY_INIT_DISP_CHAN 0
#define ENERGY_INIT_START_TIME 0.0
#define ENERGY_INIT_END_TIME -1.0
#define ENERGY_INIT_DEBUG 0
#define ENERGY_INIT_BORDER_WIDTH 0
#define ENERGY_INIT_HIGHLIGHT_WIDTH 0
#define ENERGY_INIT_SF_D 0.0
#define ENERGY_INIT_FFT_ORDER 256
#define ENERGY_INIT_WINLEN 0.025
#define ENERGY_INIT_FRAMELEN 0.010
#define ENERGY_INIT_PREEMPH 0
#define ENERGY_INIT_PRE_FLAG 0
#define ENERGY_INIT_WINDOW (char*)"hamming"

// set the minimum number of args to the widget
//
#define ENERGY_MINIMUM_NUM_ARGS 2

// set the number of vertices in a polygon which describes this item
// in this case it is a rectangle
//
#define ENERGY_POLY_VERTICES 4

// set flag constants
//
#define ENERGY_REDRAW_NEEDED 0x1

// define minimum log energy value we will plot
//
#define ENERGY_MIN_VALUE (double)1.0
  
// end of file
//
#endif



