// file: energy_dest_0.cc
//

// isip include files
//
#ifndef __ISIP_ENERGY_PLOT
#include "energy_plot.h"
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// function: energy_plot_destroy_cc
//
// parameters:
//     Tk_Canvas canvas: the canvas containing this widget
//     Tk_Item* item_ptr: a pointer to the energy_plot widget
//     Display* display: display containing window for the canvas
//
// returns: int indicating status
//
// this function frees the resources used by the energy_plot widget
//
void energy_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display) {

  // cast the client_data to a energy plot object
  //
  Energy_plot_item* energy_plot = (Energy_plot_item*) item_ptr;

  // free up the graphic resources
  //
  // free the highlight graphics context
  //
  if (energy_plot->highlight_gc != None) {
    Tk_FreeGC(display, energy_plot->highlight_gc);
  }

  // free the text graphics context
  //
  if (energy_plot->text_gc != None) {
    Tk_FreeGC(display, energy_plot->text_gc);
  }

  // free memory for the coord pointer
  //
  if (energy_plot->coord_ptr != NULL) {
    Tcl_Free((char*)energy_plot->coord_ptr);
  }

  // free memory for the coord pointer
  //
  if (energy_plot->plotted_points != NULL) {
    Tcl_Free((char*)energy_plot->plotted_points);
  }

  // free memory for pixmap
  //
  if (energy_plot->pixmap != None) {
    Tk_FreePixmap(display, energy_plot->pixmap);
    energy_plot->pixmap = None;
  }

  // exit gracefully
  //
}

