// file: energy_comp_0.cc
//
// computes energy of the data
//

// local include files
//
#include "energy_plot.h"
#include "energy_plot_constants.h"

// function: compute_energy_cc
//
// arguments:
//
//  double* data: (input/output) sampled data
//  int_4 num_samples: (input) number of samples in the data stream
//  double& energy: (input) average energy of the signal
//  
// return value: logical indicating status
//
logical_1 compute_energy_cc(double* data_a, int_4 num_samples_a,
			    double& energy_a, double rms_scale_factor,
			    double amplitude_scale_factor) {

  // check for null data
  //
  if (data_a == (double*)NULL) {
    return ISIP_FALSE;
  }

  // define local variables
  //
  energy_a = (double)0.0;
  
  // loop over all data
  //
  for (int_4 samp_num = 0; samp_num < num_samples_a; samp_num++) {

    // compute the sum of all the energy
    //
    energy_a += data_a[samp_num] * data_a[samp_num];
  }

  // normalize the computed energy (rms)
  //
  energy_a /= (double)num_samples_a;
  energy_a = sqrt(energy_a);
  energy_a = rms_scale_factor * amplitude_scale_factor * energy_a;

  // exit gracefully
  //
  return ISIP_TRUE;
}
