// file: energy_cmd_0.cc
//

// isip include files
//
#ifndef __ISIP_ENERGY_PLOT
#include "energy_plot.h"
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// function: energy_plot_cmd_cc
//
// parameters:
//     Tcl_Interp* interpreter: a tcl interpreter object
//     Tk_Canvas canvas: canvas to hold the new item
//     Tk_Item* item_ptr: record to hold the new item, the header has been
//                        initialized by the caller
//     int argc: number of arguments for this widget
//     Tcl_Obj* const* argv: arguments for this widget
//
// returns: int indicating status
//
// this function initializes the energy plot widget
//
int energy_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		       Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv) {

  // cast the item pointer to the proper type for this widget
  //
  Energy_plot_item* energy_plot = (Energy_plot_item*) item_ptr;

  // check the number of arguments (if this is used directly from tcl)
  //
  if (argc < 0) {
    Tcl_AppendResult(interpreter, "wrong # args: should be\"",
		     Tk_PathName(Tk_CanvasTkwin(canvas)), "create",
		     item_ptr->typePtr->name, "?options?\"",
		     (char*) NULL);
    return TCL_ERROR;
  }
  
  // allocate and initialize the widget record
  //
  energy_plot->interpreter = interpreter;
  energy_plot->canvas = canvas;
  energy_plot->x = ENERGY_INIT_X;
  energy_plot->y = ENERGY_INIT_Y;
  energy_plot->width = ENERGY_INIT_WIDTH;
  energy_plot->height = ENERGY_INIT_HEIGTH;
  energy_plot->coord_ptr =
    (double*) Tcl_Alloc(2*ENERGY_POLY_VERTICES*sizeof(double));
  energy_plot->plotted_points = ENERGY_INIT_POINTS;
  energy_plot->num_points = ENERGY_INIT_NUM_POINTS;
  energy_plot->pixmap = None;  
  energy_plot->border_width = ENERGY_INIT_BORDER_WIDTH;
  energy_plot->relief = TK_RELIEF_FLAT;
  energy_plot->background = (Tk_3DBorder)NULL;
  energy_plot->foreground = (XColor*)NULL;
  energy_plot->highlight = (XColor*)NULL;
  energy_plot->highlight_bg = (XColor*)NULL;
  energy_plot->highlight_gc = None;
  energy_plot->text_gc = None;
  energy_plot->highlight_width = ENERGY_INIT_HIGHLIGHT_WIDTH;
  energy_plot->padX = ENERGY_INIT_PADX;
  energy_plot->padY = ENERGY_INIT_PADY;
  energy_plot->flags = ENERGY_INIT_FLAGS;
  energy_plot->font = (char*)ENERGY_DEFAULT_FONT;  
  energy_plot->file_name_d = ENERGY_INIT_FILE;
  energy_plot->num_chans_d = ENERGY_INIT_NUM_CHAN;
  energy_plot->num_bytes_d = ENERGY_INIT_NUM_BYTE;
  energy_plot->display_channel_d = ENERGY_INIT_DISP_CHAN;
  energy_plot->sf_d = ENERGY_INIT_SF_D;
  energy_plot->swap_byte_flag_d = ENERGY_FALSE;  
  energy_plot->start_time_d = ENERGY_INIT_START_TIME;  
  energy_plot->end_time_d = ENERGY_INIT_END_TIME;
  energy_plot->debug_level_d = ENERGY_INIT_DEBUG;
  energy_plot->win_length_d = ENERGY_INIT_WINLEN;
  energy_plot->frame_length_d = ENERGY_INIT_FRAMELEN;
  energy_plot->pre_emph_coeff_d = ENERGY_INIT_PREEMPH;
  energy_plot->pre_emph_flag_d = ENERGY_INIT_PRE_FLAG;
  energy_plot->window_option_d = (char*)ENERGY_INIT_WINDOW;
    
  // parse the command line arguments
  //
  if (energy_plot_config_cc(interpreter, canvas, item_ptr,
			    argc-ENERGY_MINIMUM_NUM_ARGS,
			    argv+ENERGY_MINIMUM_NUM_ARGS, 0) != TCL_OK) {
    energy_plot_destroy_cc(canvas, item_ptr,
			   Tk_Display(Tk_CanvasTkwin(canvas)));
    return TCL_ERROR;
  }

  // get the upper left hand corner point of this item on the canvas
  // the height and width should be specified through the configure options
  //
  char x_loc[ISIP_MAX_STRING_LENGTH];
  char y_loc[ISIP_MAX_STRING_LENGTH];
  sprintf(x_loc, "%d", energy_plot->x_loc);
  sprintf(y_loc, "%d", energy_plot->y_loc);  
  if ((Tk_CanvasGetCoord(interpreter, canvas, x_loc, &energy_plot->x)
       != TCL_OK) || (Tk_CanvasGetCoord(interpreter, canvas, y_loc,
					&energy_plot->y) != TCL_OK)) {
    return TCL_ERROR;
  }
  
  // exit gracefully
  //
  return TCL_OK;

}






