// file: energy_bbox_0.cc
//

// isip include files
//
#ifndef __ISIP_ENERGY_PLOT
#include "energy_plot.h"
#endif

#ifndef __ISIP_ENERGY_PLOT_CONSTANTS
#include "energy_plot_constants.h"
#endif

// function: energy_plot_bbox_cc
//
// parameters:
//     Tcl_Interp* interpreter: interpreter for this widget
//     Tk_Canvas canvas: canvas containing this widget
//     Energy_plot_item* energy_plot: energy plot widget
//
// returns: int indicating status
//
// this function computes the bounding box of all the pixes that may be
// drawn as part of this item. in addition it recomputes all of the
// geometry information used to display a text item or check for mouse
// hits
//
int energy_plot_bbox_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Energy_plot_item* energy_plot) {

  // declare local variables
  //
  int left_x, top_y;

  // declare buffer memory
  //
  char buffer[ENERGY_POLY_VERTICES*2][ISIP_MAX_STRING_LENGTH];
  
  // find the upper left coordinates of the widget round to the nearest
  // pixel
  //
  left_x = (int) (energy_plot->x_loc);
  top_y = (int) (energy_plot->y_loc);

  // set the bounding box for the item - if display is cut off then we may
  // need a fudge factor here
  //
  energy_plot->header.x1 = left_x;
  energy_plot->header.y1 = top_y;
  energy_plot->header.x2 = left_x + energy_plot->width;
  energy_plot->header.y2 = top_y + energy_plot->height;  
  
  // compute the canvas coordinates of a polygon describing the area taken
  // up by this widget. this has to be done by first writing to strings
  // and then getting the coords from tk using those strings. 
  //
  sprintf(buffer[0], "%d", energy_plot->header.x1);
  sprintf(buffer[1], "%d", energy_plot->header.y1);
  sprintf(buffer[2], "%d", energy_plot->header.x2);
  sprintf(buffer[3], "%d", energy_plot->header.y1);
  sprintf(buffer[4], "%d", energy_plot->header.x2);
  sprintf(buffer[5], "%d", energy_plot->header.y2);
  sprintf(buffer[6], "%d", energy_plot->header.x1);
  sprintf(buffer[7], "%d", energy_plot->header.y2);

  // toggle through and convert each vertex
  //
  for (int_4 i = 0; i < 2*ENERGY_POLY_VERTICES; i++) {
    if (Tk_CanvasGetCoord(interpreter, canvas, buffer[i],
			  &energy_plot->coord_ptr[i]) != TCL_OK) {
      return TCL_ERROR;
    }
  }

  // exit gracefully
  //
  return TCL_OK;
}










