// file $ISIP_TRANSCRIBER/util/run_tcl/rt_init_0.cc
//

// system include files
//
#include <tk.h>

// isip include files
//
#include "run_tcl.h"

// method: run_tcl_init_cc
//
// arguments:
//     Tcl_Interp* interpreter: a tcl interpreter
//
// return: int indicating status
//
int run_tcl_init_cc(Tcl_Interp* interpreter) {

  // initialize tcl to run our program
  //
  if (Tcl_Init(interpreter) == TCL_ERROR) {
    return TCL_ERROR;
  }

  // initialize tk to run our program
  //
  if (Tk_Init(interpreter) == TCL_ERROR) {
    return TCL_ERROR;
  } 

  // add the signal plot
  //
  Tk_CreateItemType(&Signal_plot_type);

  // add the energy plot
  //
  Tk_CreateItemType(&Energy_plot_type);

  // add the spectrogram plot
  //
  Tk_CreateItemType(&Spec_plot_type);

  // exit gracefully
  //
  return TCL_OK;
}

