# file: $isip/util/misc/make/compile.make

# this makefile contains a standard set of dependencies and targets
# that are used by all makefiles in the environment.
#

#------------------------------------------------------------------------------
#
# define variables section
#
#------------------------------------------------------------------------------

# create filenames
#
SRCS = $(wildcard $(ISIP_FILES))
OBJS = $(subst .cc,.o,$(SRCS))

# define flags for the C++ and C compilers
#
I_FLAGS      = $(ISIP_IFLAGS) $(ISIP_INCLUDE)
CPLUS_FLAGS  = -w $(ISIP_CFLAGS) -c
C_FLAGS      =

# create the c_flags from the command line arguments
#
ifeq "$(origin DEBUG)" "command line"
C_FLAGS      += -g
endif
ifeq "$(origin OPTIMIZE)" "command line"
C_FLAGS      += -O
endif

# define dependencies: note that we include, by default, a makefile
#  located in the current directory, so that changes to the makefile
#  will trigger a make.
#
ALL_DEPS = ./GNUmakefile $(ISIP_DEPS)

# define suffixes
#
.SUFFIXES: .cc

# make sure we clean up
#  note: this code is executed ALL the time
#
.DONE:

# make everything silent
#
.SILENT:

#------------------------------------------------------------------------------
#
# define targets and dependencies
#
#------------------------------------------------------------------------------

# make all objects
#
all: $(OBJS)

# include file dependencies (define only the significant relationships)
#
$(OBJS): $(ALL_DEPS)

# define source file dependencies
#
.cc.o:
	echo $(ISIP_CPLUS_COMPILER) $(I_FLAGS) $(CPLUS_FLAGS) $(C_FLAGS) $<
	$(ISIP_CPLUS_COMPILER) $(I_FLAGS) $(CPLUS_FLAGS) $(C_FLAGS) $<

# install into a library
#
install: $(OBJS)
	echo "> installing in" $(ISIP_OLIB)
	ar r $(ISIP_OLIB) $(OBJS)

# clean up (the -rm lets make continue after errors)
#
clean:
	echo "> removing" $(OBJS)
	-rm $(OBJS)

# check existence
#
check: $(SRCS)

#
# end of file
