/* $Id: vatest.c,v 1.1 1994/04/07 20:45:16 bst Exp $
 *
 * Copyright 1994 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Thu Apr 7 16:45:09 EDT 1994
 *
 * Revision History: $Log: vatest.c,v $
 * Revision 1.1  1994/04/07  20:45:16  bst
 * Initial revision
 *
 */
/* Check if varargs or stdargs work OK */
#include <stdio.h>

#ifdef STDARG
#include <stdarg.h>

#ifdef __STDC__
int test(char *fmt,...)
#else
int test(fmt)
char *fmt;
#endif
{
    int x;
    va_list args;
    va_start(args,fmt);
/*     vfprintf(stdout,fmt,args); */
    x = va_arg(args,int);
    va_end(args);
    return x;
}
#else
#include <varargs.h>

int test(fmt, va_alist)
char *fmt;
va_dcl
{
    int x;
    va_list ap;
    va_start(ap);
/*    vfprintf(stdout,fmt,ap); */
    x=va_arg(ap, int);
    va_end(ap);
    return x;
}
#endif

main()
{
    if ((test("One=%d\n",1) == 1)  && (test("Two=%d\n",2)==2))
	exit(0);
    printf("test(Three=%%d,3)=0x%x\n",test("Three=",3));
    exit(1);
}
