/* $Id: transfer.c,v 1.1 1998/04/16 18:21:31 hamaker Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:31:18 EDT 1991
 *
 * Revision History: $Log: transfer.c,v $
 * Revision History: Revision 1.1  1998/04/16 18:21:31  hamaker
 * Revision History: Initial revision
 * Revision History:
 * Revision 2.27  1996/03/26  01:21:25  bst
 * Use OPTIMUMU_TRANSFER_LENGTH for BUFSIZE instead of 64512
 *
 * Revision 2.26  1994/05/12  03:04:54  bst
 *  Use DAT-Link bitsPerSamples instead of file bitsPerSample for
 * converting between samples and bytes. (messed up counts for I/O when these were not equal)
 *
 * Revision 2.25  1993/10/04  02:00:45  bst
 * Removed extern decl.
 *
 * Revision 2.24  1993/08/10  02:51:20  bst
 * Moved min() macro to support.h
 * Coerce %l args to long.
 *
 * Revision 2.23  1993/07/08  18:37:47  bst
 * Use SamplesToBytes(), BytesToSamples() macros.
 * Moved these macros to support.h
 *
 * Revision 2.22  1993/06/23  20:38:22  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.21  1993/06/09  14:16:23  bst
 * Added coercion.
 *
 * Revision 2.20  1993/05/26  13:33:05  bst
 * Removed extern of _NAxfrErrorNames[] (in NAlibint.h now).
 *
 * Revision 2.19  1993/04/12  02:29:34  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.18  1993/03/19  16:16:24  bst
 * Make sure recording has begun before printing "Recording..."
 *
 * Revision 2.17  1993/03/01  04:09:09  bst
 * Use malloc() instead of static storage for buffers.
 *
 * Revision 2.16  1993/02/07  19:37:48  bst
 * Added unused() #pragma.
 *
 * Revision 2.15  1993/02/04  23:21:25  bst
 * Only use EPIPE if it has been defined.
 *
 * Revision 2.14  1992/08/18  01:13:51  bst
 * Use cleanup() instead of exit() to guarantee data connection is closed.
 *
 * Revision 2.13  1992/08/11  20:59:13  bst
 * Count bytes instead of samples and convert to samples on return.
 *
 * Revision 2.12  1992/07/05  03:14:39  bst
 * Allow file writes to write partial buffers - move rest to beginning of
 *    next buffer.
 *
 * Revision 2.11  1992/05/25  17:14:53  bst
 * Don't bother blocking together reads.
 *
 * Revision 2.10  1992/05/10  19:07:01  bst
 * Count samples instead of words
 *
 * Revision 2.9  1992/04/07  23:00:45  bst
 * Use DebugCheck() instead of Debug() to avoid format warning.
 *
 * Revision 2.8  1992/01/30  06:12:57  bst
 * Added ARGSUSED comment.
 * Coerce enums to int when needed
 *
 * Revision 2.7  1992/01/24  05:07:59  bst
 * Added 'Recording...' message.
 *
 * Revision 2.6  1992/01/22  21:17:28  bst
 * Added coercion of an enum to int to avoid warnings.
 *
 * Revision 2.5  1992/01/20  03:57:25  bst
 * Changed 'dlplay/dlrecord' to 'naplay/narecord' in one comment.
 *
 * Revision 2.4  1991/12/16  05:25:35  bst
 * Fixed bug in error message for playback error.
 * Return -ve of sample count if there was a NetAudio transfer error.
 *
 * Revision 2.3  1991/12/10  22:49:27  bst
 * Merged in changes from 1.11->1.14
 *
 * Revision 2.2  1991/12/08  22:22:23  bst
 * Removed bzero() declarations.
 *
 * Revision 2.1  1991/12/08  21:08:19  bst
 * Network version.
 *
 * Revision 1.14  1991/12/08  20:24:29  bst
 * Removed bzero() declarations.
 *
 * Revision 1.13  1991/12/06  02:18:39  bst
 * Keep transfer counts in words not samples. (just renaming of variables)
 * Run forever if nwords < 0 not just if nwords==-1
 *
 * Revision 1.12  1991/11/22  05:03:34  bst
 * Print progress messages to stderr not stdout.
 *
 * Revision 1.11  1991/11/11  04:15:04  bst
 * Use new Debug() procedure.
 *
 * Revision 1.10  1991/11/09  03:46:56  bst
 * Moved interrupt handling to execute.c
 *
 * Revision 1.9  1991/11/08  06:04:59  bst
 * Added ptime() call to monitor progress.
 *
 * Revision 1.8  1991/11/04  01:45:32  bst
 * Removed handling of null I/O (with fd<0)
 * Use indirect methods to do file I/O.
 *
 * Revision 1.7  1991/11/03  18:55:32  bst
 * Added sampsBeforeStart argument to control when to call beginWrite()
 *
 * Revision 1.6  1991/10/20  18:21:10  bst
 * Use memset() for bzero() on MAC.
 *
 * Revision 1.5  1991/10/17  21:15:23  bst
 * Define bzer() as memset() on Mac.
 *
 * Revision 1.4  1991/10/03  14:20:32  bst
 * Restore SIGINT to default before exitting transfer.
 * Added null I/O capability if fd=-1
 *
 * Revision 1.3  1991/09/29  06:47:39  bst
 * Use dat_nAvail() instead of dat_waitForData()
 *
 * Revision 1.2  1991/09/27  14:58:48  bst
 * Wait for DAT-Link's internal buffer to receive some data before beginning reads.
 *
 * Revision 1.1  1991/08/05  06:32:45  bst
 * Initial revision
 */
/* Transfer subroutine for narecord/naplay */

#include "playrec.h"
#include <assert.h>
#include "support.h"

#define BUFSIZE OPTIMUM_TRANSFER_LENGTH

/* Return number of samples processed, -ve if transfer error occurred */
/*ARGSUSED*/
int32 transfer(file,dt,nsamples,samplesBeforeStart)
     SampFile *file;     /* File I/O class */
     NAport *dt;  /* Descriptor for connection to DAT-Link */
     int32 nsamples; /* Number of samples to transfer or -1 */
     int32 *samplesBeforeStart;
{
#ifdef RECORD
#ifdef PRAGMA_UNUSED
#pragma unused(samplesBeforeStart)
#endif /* PRAGMA_UNUSED */
#endif /* RECORD */
  int i;	        
  int32 byteCount = 0;	 /* Number of samples processed */
  int tfdebug = DebugCheck("transfer",2);
  int bitsPerSample = file->precision * ((file->channels==3)?2:1);
  /* Make sure each buffer contains an integer number of samples */
  int32 bufsize = (BUFSIZE*4/bitsPerSample)*(bitsPerSample/4);
  int32 bufFilled = 0;	/* Number of bytes already in \'buffer\' */
  static byte *buffer = 0;
  
  Debug("transfer",1,"sampleSize=%d, bitsPerSample=%d\n",
	file->sampleSize, bitsPerSample);
  if (buffer == 0)
    buffer = (byte *)malloc(BUFSIZE);
  
#ifdef RECORD
  /* Start recording */
  NABegin(dt,NA_RECORD);
  {
    NAinfo info;
    NAGetInfo(dt,&info);
  }
  fprintf(stderr,"Recording...\n");
#endif
  
  /* Main record loop */
  while ((nsamples < 0) || (byteCount < SamplesToBytes(nsamples,bitsPerSample))) {
    int32 numToWrite,nwrote;
#ifdef RECORD
    int32 nread = NARead(dt,(char *)&buffer[bufFilled],bufsize-bufFilled);
    if (nread <= 0) {
      if ((nread == 0)
#ifdef EPIPE
	  || (errno == EPIPE)
#endif
	  ) {
	NAinfo tmpinfo;
	NAGetInfo(dt,&tmpinfo);
	fprintf(stderr,"Transfer error: %s\n",
		_NAxfrErrorNames[(int)tmpinfo.record.error]);
	return -BytesToSamples(byteCount,bitsPerSample);
      }
      perror("NARead");
      cleanup(7);
    }
#else /* RECORD */
    int32 nread = (*file->read)(file,&buffer[bufFilled],bufsize-bufFilled);
#endif /* RECORD */

#ifndef RECORD    
    // This would be the place to do the IO manipulation
    //
    if (out_mode == NA_CHANNELS_LEFT) {
      for (i = 0; i < nread; i+=4) {
	buffer[i+2] = buffer[i];
	buffer[i+3] = buffer[i+1];
      }
    }
    else if (out_mode == NA_CHANNELS_RIGHT) {
      for (i = 0; i < nread; i+=4) {
	buffer[i] = buffer[i+2];
	buffer[i+1] = buffer[i+3];	
      }
    }
#endif
    if (nread <= 0)
      return BytesToSamples(byteCount,bitsPerSample);
    if (nsamples >= 0)
      numToWrite = min(SamplesToBytes(nsamples,bitsPerSample)-byteCount,
		       nread+bufFilled);
    else
      numToWrite = nread+bufFilled;
    
    assert(numToWrite > 0);
    
#ifdef RECORD
    nwrote = (*file->write)(file,buffer,numToWrite);
    if (nwrote > 0)
      byteCount += nwrote;
    else if (nwrote < 0) {
      perror("File write error");
      return -BytesToSamples(byteCount,bitsPerSample);
    }
    /* nwrote may be less than numToWrite if sampleSize is not a
       multiple of 8 */
    if (nwrote == numToWrite)
      bufFilled = 0;
    else {
      /* Move remaining bytes to beginning of buffer */
      bufFilled = numToWrite-nwrote;
      longmemcpy(buffer,&buffer[nwrote],(unsigned int32)bufFilled);
    }
#else /* RECORD */
    nwrote = NAWrite(dt,(char *)buffer,numToWrite);
    if (nwrote > 0)
      byteCount += nwrote;
    if (nwrote != numToWrite) {
      if ((nwrote >= 0)
#ifdef EPIPE
	  || (errno == EPIPE)
#endif
	  ) {
	NAinfo tmpinfo;
	NAGetInfo(dt,&tmpinfo);
	fprintf(stderr,"Transfer error: %s\n",
		_NAxfrErrorNames[(int)tmpinfo.playback.error]);
	return -BytesToSamples(byteCount,bitsPerSample);
      }
      perror("NAWrite");
      cleanup(7);
    }
#endif /* RECORD */
    
    if (tfdebug)
      Debug("transfer",2,"Transferred %ld bytes; count=%ld, nsamples=%ld\n",
	    (long)nwrote,(long)BytesToSamples(byteCount,bitsPerSample),
	    (long)nsamples);
    
#ifndef RECORD
    if (samplesBeforeStart) {
      *samplesBeforeStart -= BytesToSamples(nwrote,bitsPerSample);
      if (*samplesBeforeStart <= 0) {
	Debug("transfer",1,"Starting output\n");
	NABegin(dt,NA_PLAY);
#ifdef PTIME
	ptime("start output");
#endif
	samplesBeforeStart = 0;
      }
    }
#endif
  }
  return BytesToSamples(byteCount,bitsPerSample);
}
