/* $Id: params.h,v 1.1 1998/04/16 18:21:31 hamaker Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Nov 8 00:57:42 EST 1991
 *
 * Revision History: $Log: params.h,v $
 * Revision History: Revision 1.1  1998/04/16 18:21:31  hamaker
 * Revision History: Initial revision
 * Revision History:
 * Revision 2.8  1993/06/23  20:38:22  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.7  1993/04/12  02:29:24  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.6  1992/05/10  19:06:48  bst
 * Added 'precision' and 'encoding' fields.
 *
 * Revision 2.5  1992/02/17  04:51:56  bst
 * Made format 'const'
 *
 * Revision 2.4  1992/01/30  06:12:40  bst
 * Made clock a 'NAclock' instead of 'int'.
 *
 * Revision 2.3  1992/01/27  06:22:06  bst
 * Added 'unit' to cmd structure.
 *
 * Revision 2.2  1992/01/22  21:16:44  bst
 * Added additional fields so Params can hold all command line options.
 *
 * Revision 2.1  1991/12/08  21:08:19  bst
 * Network version.
 *
 * Revision 1.2  1991/11/11  04:14:29  bst
 * Removed 'unit' from structure.
 *
 * Revision 1.1  1991/11/08  06:06:04  bst
 * Initial revision
 *
 */
/* Command line arguments */
#define MAXNAMES 100

typedef struct {
    const char *unit;		 /* NetAudio server */
    int  cbits;		 	 /* 0-no control bits, 1-one copy, 2-continuous */
    char *cfilename;		 /* Name of file for control info */
    int32 nsamples;		 /* Number of samples to transfer */
    float duration;		 /* Duration of transfer */
    int32 position;     		 /* Position to begin transfers in file or -1 */
    int autoStart;		 /* Automatic start/stop DAT machine */
    int channels;		 /* Channels to use */
    const char *format;		 /* File format */
    int numfiles;		 /* Number of file name arguments */
    char *names[MAXNAMES];	 /* File name arguments */
    int source;			 /* Input source */
    float sampleRate;		 /* Internal sample rate */
    float externalRate;		 /* External sample rate */
    int precision;		 /* Precision in bits/sample */
    int encoding;		 /* Data encoding */
#ifdef RECORD
    int skipSilence;		 /* 1 to skip silence */
#else
    float bufferTime;		 /* Number of seconds to buffer before starting
				    output */
    int repeats;		 /* Number of repetition of input */
    int32 seek;			 /* Position to seek to in file for playback */
    int consumer;		 /* Generate S/P DIF not Pro if true */
    int master;			 /* 1 to generate clock */
    NAclock clock;		 /* Clock source */
#endif /* RECORD */
} Params;


