/* $Id: main.c,v 1.1 1998/04/16 18:21:31 hamaker Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Nov 8 00:57:39 EST 1991
 *
 * Revision History: $Log: main.c,v $
 * Revision History: Revision 1.1  1998/04/16 18:21:31  hamaker
 * Revision History: Initial revision
 * Revision History:
 * Revision 2.7  1996/03/21  16:43:32  bst
 * Use __MWERKS__ instead of THINK_C for SIOUX
 *
 * Revision 2.6  1993/03/01  04:08:38  bst
 * Use 'console.h' under THINK-C.
 *
 * Revision 2.5  1992/12/31  05:03:05  bst
 * Use Execute() return value.
 *
 * Revision 2.4  1992/04/09  23:50:14  bst
 * Added handling of multiple files on command line.
 *
 * Revision 2.3  1992/01/27  06:21:51  bst
 * Use InitDefaults without options processing.
 *
 * Revision 2.2  1992/01/22  21:16:18  bst
 * Removed use of 'info' - Execute() now handles it.
 *
 * Revision 2.1  1991/12/08  21:08:19  bst
 * Network version.
 *
 * Revision 1.3  1991/11/11  04:14:09  bst
 * Use new options processing - dat_initDefaults()
 *
 * Revision 1.2  1991/11/08  21:25:49  bst
 * Don't pass command line arguments to sampfile
 *
 * Revision 1.1  1991/11/08  06:06:04  bst
 * Initial revision
 */
#include "playrec.h"

#ifdef __MWERKS__
#include <console.h>
#endif

void main(argc,argv)
int argc;
char *argv[];
{

    SampFile *file;		/* Structure for file I/O */
    Params cmd;			/* Parameters for playback */

#ifdef __MWERKS__
    argc = ccommand(&argv);
#endif

#ifdef PTIME
    ptime("main");
#endif
#ifdef macintosh
    setvbuf(stdout,NULL,_IOLBF,0);
#endif

    InitDefaults(argv[0]);

    /* Set defaults for command line */
    CmdSetDefaults(&cmd);

    /* Parse command line - set fields in 'cmd' and 'file' */
    ParseCmdLine(argc,argv,&cmd);

    if (cmd.numfiles == 0) {
	file = (SampFile *)malloc(sizeof(*file));
	SampFileSetDefaults(&file[0],argc,argv);
    }
    else {
	int i;
	file = (SampFile *)malloc(sizeof(*file)*cmd.numfiles);
	/* Set File Structure defaults */
	for (i=0;i<cmd.numfiles;i++)
	    SampFileSetDefaults(&file[i],argc,argv);
    }

    /* Execute the command */
    exit(Execute(&cmd,file));
}

