/* $Id: cubits.c,v 1.1 1998/04/16 18:21:31 hamaker Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Nov 3 20:42:24 EST 1991
 *
 * Revision History: $Log: cubits.c,v $
 * Revision History: Revision 1.1  1998/04/16 18:21:31  hamaker
 * Revision History: Initial revision
 * Revision History:
 * Revision 2.3  1992/02/17  04:50:19  bst
 * Added VerifyCUBits()
 *
 * Revision 2.2  1992/01/22  21:13:43  bst
 * Made DATsrate double instead of int - was causing bad calls with non-ANSI
 *
 * Revision 2.1  1991/12/08  21:08:19  bst
 * Network version.
 *
 * Revision 1.2  1991/11/08  05:59:45  bst
 * Don't set c.s. bits unless they're different from DAT-Link defaults.
 * Don't set u bits unless they're non-zero.
 * Allow variable length u bit sections of files.
 *
 * Revision 1.1  1991/11/04  01:46:34  bst
 * Initial revision
 *
 */
#include "playrec.h"

void ReadCUBits(sect,cfilename)
NAinfosect *sect;
const char *cfilename;
{
    /* Transfer control bits between cfilename and DATLink info struct */
    FILE *fd;
    int i,j;

    fd = fopen(cfilename,"r");
    if (fd == NULL) {
	fprintf(stderr,"Unable to open %s for control information\n",
		cfilename);
	exit(5);
    }
    
    for (i=0;i<24;i++) {
	int cb;
	sect->leftCS[i] = 0;
	for (j=0;j<8;j++) {
	    cb = fgetc(fd);
	    if ((cb != '0') && (cb != '1')) {
		fprintf(stderr,"Error reading C bits near line %d of %s\n",
			i+1,cfilename);
		exit(6);
	    }
	    sect->leftCS[i] |= (cb=='1')?(1<<j):0;
	}
	cb =fgetc(fd);
    }
    
    for (i=0;i<24;i++) {
	int cb;
	sect->rightCS[i] = 0;
	for (j=0;j<8;j++) {
	    cb = fgetc(fd);
	    if ((cb != '0') && (cb != '1')) {
		fprintf(stderr,"Error reading C bits near line %d of %s\n",
			i+1,cfilename);
		exit(6);
	    }
	    sect->rightCS[i] |= (cb=='1')?(1<<j):0;
	}
	cb =fgetc(fd);
    }
    
    for (i=0;i<sizeof(sect->user);i++) {
	int cb;
	sect->user[i] = 0;
	for (j=0;j<8;j++) {
	    if ((cb = fgetc(fd)) == EOF)
		goto ubitsdone;
	    if ((cb != '0') && (cb != '1')) {
		fprintf(stderr,"Error reading U bits near line %d of %s\n",
			i+25,cfilename);
		exit(6);
	    }
	    sect->user[i] |= (cb=='1')?(1<<j):0;
	}
	/* Skip newline character */
	cb=fgetc(fd);
    }
  ubitsdone:
    fclose(fd);
}

void SetDefaultCUBits(sect,consumer,DATsrate)
NAinfosect *sect;
int consumer;
double DATsrate;
{
    /* cbits == 0 */
    bzero((char *)sect->leftCS,sizeof(sect->leftCS));
    if (consumer) {
	sect->leftCS[0] = 0x04;   /* Copy permitted */
	sect->leftCS[1] = 0x0;   /* User bits unused */
	switch ((int)(DATsrate+0.5)) {
	  case 32000:
	    sect->leftCS[3] = 0x03;
	    break;
	  case 44100:
	    sect->leftCS[3] = 0x00;
	    break;
	  case 48000:
	    sect->leftCS[3] = 0x02;
	    break;
	}
    }
    else {
	/* Pro standard */
	switch ((int)(DATsrate+0.5)) {
	  case 32000:
	    sect->leftCS[0] = 0xc1;
	    break;
	  case 44100:
	    sect->leftCS[0] = 0x41;
	    break;
	  case 48000:
	    sect->leftCS[0] = 0x81;
	    break;
	}
    }
    /* Right C bits the same as left */
    memcpy(sect->rightCS,sect->leftCS,sizeof(sect->leftCS));
    Debug("cubits",1,"SetDefaultCUBits(%s,%f) -> %02x%02x%02x%02x...\n",
	  consumer?"consumer":"pro",DATsrate,
	  sect->leftCS[0],sect->leftCS[1],sect->leftCS[2],sect->leftCS[3]);
}

/* Make sure CS bits are consistent with settings */
void VerifyCUBits(sect,consumer,DATsrate)
NAinfosect *sect;
int consumer;
double DATsrate;
{
    int error = 0;

    /* cbits == 0 */
    if (consumer) {
	int rbits = sect->leftCS[3]&0xf;
	if (((sect->rightCS[3] & 0xf) != rbits) ||
	    ((sect->leftCS[0]&1) != (sect->rightCS[0]&1))) {
	    fprintf(stderr,"Left and right channel status are inconsistent.\n");
	    goto cuerr;
	}
	if (sect->leftCS[0]&1) {
	    fprintf(stderr,"Channel status indicates Pro mode, but consumer mode was requested.\n");
	    goto cuerr;
	}
	switch ((int)(DATsrate+0.5)) {
	  case 32000:
	    if (rbits != 0x3)
		error = 1;
	    break;
	  case 44100:
	    if (rbits != 0x0)
		error = 1;
	    break;
	  case 48000:
	    if (rbits != 0x2)
		error = 1;
	    break;
	}
	if (error) {
	    fprintf(stderr,"Channel status is inconsistent with a DAT sampling rate of %f.\n", DATsrate);
	    goto cuerr;
	}
    }
    else {
	/* Pro standard */
	int rbits = sect->leftCS[0]&0xc0;
	if (((sect->rightCS[0] & 0xc0) != rbits) ||
	    ((sect->leftCS[0]&1) != (sect->rightCS[0]&1))) {
	    fprintf(stderr,"Left and right channel status are inconsistent.\n");
	    goto cuerr;
	}
	if ((sect->leftCS[0]&1)==0) {
	    fprintf(stderr,"Channel status indicates consumer mode, but Pro mode was requested.\n");
	    goto cuerr;
	}
	switch ((int)(DATsrate+0.5)) {
	  case 32000:
	    if (rbits != 0xc0)
		error = 1;
	    break;
	  case 44100:
	    if (rbits != 0x40)
		error = 1;
	    break;
	  case 48000:
	    if (rbits != 0x80)
		error = 1;
	    break;
	}
	if (error) {
	    fprintf(stderr,"Channel status is inconsistent with a DAT sampling rate of %f.\n", DATsrate);
	    goto cuerr;
	}
    }
    return;
  cuerr:
    fprintf(stderr,"Using default channel status instead.\n");
    SetDefaultCUBits(sect,consumer,DATsrate);
}

void StoreCUBits(sect,cfilename)
NAinfosect *sect;
const char *cfilename;
{
    /* Transfer control bits between cfilename and DATLink */
    FILE *fd;
    int i,j;

    fd = fopen(cfilename,"w");
    if (fd == NULL) {
	fprintf(stderr,"Unable to open %s for control information\n",cfilename);
	exit(5);
    }
    
    for (i=0;i<sizeof(sect->leftCS);i++) {
	for (j=0;j<8;j++)
	    fputc((sect->leftCS[i]&(1<<j))?'1':'0',fd);
	fputc('\n',fd);
    }
    
    for (i=0;i<sizeof(sect->rightCS);i++) {
	for (j=0;j<8;j++)
	    fputc((sect->rightCS[i]&(1<<j))?'1':'0',fd);
	fputc('\n',fd);
    }
    
    for (i=0;i<sizeof(sect->user);i++) {
	for (j=0;j<8;j++)
	    fputc((sect->user[i]&(1<<j))?'1':'0',fd);
	fputc('\n',fd);
    }
    
    fclose(fd);
}
