/* $Id: cmdline.c,v 1.2 1998/04/30 05:53:53 hamaker Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Nov 8 00:57:35 EST 1991
 *
 * Revision History: $Log: cmdline.c,v $
 * Revision History: Revision 1.2  1998/04/30 05:53:53  hamaker
 * Revision History: *** empty log message ***
 * Revision History:
 * Revision History: Revision 1.1  1998/04/16 18:21:31  hamaker
 * Revision History: Initial revision
 * Revision History:
 * Revision 2.22  1995/11/28  22:57:10  bst
 * Use atol() for arg to -S option instead of atoi()
 *
 * Revision 2.21  1994/08/05  17:08:08  bst
 * Changed bufferTime .datlinkrc variable to float.
 *
 * Revision 2.20  1993/11/10  00:33:06  bst
 * Added handling of -C option using NA_ENCODING_CONTROL.
 *
 * Revision 2.19  1993/09/17  13:20:10  bst
 * Fixed usage goto.
 *
 * Revision 2.18  1993/09/11  14:15:23  bst
 * Handle missing option args.
 *
 * Revision 2.17  1993/08/31  17:25:48  bst
 * Don't force external rate to the DAT rates.
 *
 * Revision 2.16  1993/08/10  02:49:43  bst
 * Use unsigned for extRate.
 * Use atol() instead of atoi()
 * Coerce %l args to long.
 *
 * Revision 2.15  1993/04/12  02:28:33  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.14  1992/07/15  23:49:43  bst
 * Increased default bufferTime to 2.
 *
 * Revision 2.13  1992/05/12  18:59:05  bst
 * Changed semantics of -S option.
 * Removed -g option.
 *
 * Revision 2.12  1992/05/10  19:05:27  bst
 * Added '-p' and '-e' options.
 *
 * Revision 2.11  1992/04/23  22:04:44  bst
 * Fixed bug that prevented use of '-S External'
 *
 * Revision 2.10  1992/04/09  23:49:46  bst
 * Added multiples files for naplay to usage message.
 *
 * Revision 2.9  1992/04/09  17:59:07  bst
 * Use strchr() instead of index()
 *
 * Revision 2.8  1992/02/12  04:33:00  bst
 * Added coercions for cmd->clock.
 *
 * Revision 2.7  1992/01/30  06:12:31  bst
 * Removed atof() declaration()
 *
 * Revision 2.6  1992/01/27  06:21:15  bst
 * Use InitDefaults without options processing.
 * Added -u option
 *
 * Revision 2.5  1992/01/24  05:07:03  bst
 * Added '-i live' for active channel input source.
 *
 * Revision 2.4  1992/01/22  21:12:37  bst
 * Store all command line options in 'cmd', not in 'info' or 'file'.
 * Added support for multiple filenames.
 *
 * Revision 2.3  1992/01/17  04:20:06  bst
 * Fixed usage messages.
 *
 * Revision 2.2  1991/12/10  22:44:22  bst
 * Changed -l,-r,-m flags to -o xxx option.
 * Added '-r rng' option.
 * Removed -p option, -n option only for recording.
 *
 * Revision 2.1  1991/12/08  21:08:19  bst
 * Network version.
 *
 * Revision 1.3  1991/11/14  01:05:54  bst
 * Removed -b option (it can be set in defaults file)
 * Set some defaults from .datlinkrc file
 *
 * Revision 1.2  1991/11/11  04:12:30  bst
 * Removed -u and -d option since initDefaults() handles them now.
 * Made argc a pointer to int.
 *
 * Revision 1.1  1991/11/08  06:06:04  bst
 * Initial revision
 *
 */
#include "playrec.h"

void CmdSetDefaults(cmd)
Params *cmd;
{
    /* Command line arguments */
    /* Settings of -1 indicate argument not specified */
    cmd->unit = 0;
    cmd->cbits = 0;	 	 /* 0-no control bits, 1-one copy, 2-continuous */
    cmd->cfilename=0;		 /* Name of file for control info */
    cmd->nsamples = -1;		 /* Number of samples to transfer */
    cmd->duration = -1;	 	 /* Duration of transfer */
    cmd->position = -1;		 /* Position to begin transfers in file or -1 */
    cmd->autoStart = GetBoolDefault("AutoStart",False);
    				/* Automatic start/stop DAT machine */
    cmd->format = 0;		 /* File format */
    cmd->numfiles = 0;		 /* Number of command line files */
    cmd->channels = -1;
    cmd->source = -1;
    cmd->externalRate = -1;
    cmd->sampleRate = -1;
    cmd->precision = -1;
    cmd->encoding = -1;
#ifdef RECORD
    cmd->skipSilence = -1;
#else

    /* changed by ISIP, 04_29_98 . The default buffer time is way too high
       for short outputs. Changed from 2.0 to 1/8 of a second
       */
    cmd->bufferTime = GetFloatDefault("bufferTime",0.125);
    			/* Number of seconds to buffer before starting output */
    cmd->repeats = 1;		 /* Number of repetition of input */
    cmd->seek = 0;		 /* Position to seek to in file for playback */
    cmd->consumer = GetBoolDefault("Consumer",True);
    				/* Generate S/P DIF not Pro if true */
    cmd->master = -1;
    cmd->clock = (NAclock)-1;
#endif /* RECORD */
}

void ParseCmdLine(argc,argv,cmd)
int argc;
char *argv[];
Params *cmd;
{
#ifndef RECORD
    char *sep;
#endif
    int c;

#ifdef RECORD
    while ((c = getopt(argc,argv,"aCc:d:e:f:i:n:o:p:P:qs:t:u:")) != -1)
#else
    while (
(
c = getopt(argc,argv,"AaCc:d:e:f:o:r:p:P:R:s:S:t:u:m:")
) 
!= -1)
#endif
	switch (c) {
#ifndef RECORD
	  case 'A':  /* Generate AES/EBU */
	    cmd->consumer = False;
	    break;
#endif
	  case 'a':  /* Auto start/stop DAT */
	    if (getenv("DL_RC") == NULL) {
		fprintf(stderr,"DL_RC environment variable must be set to use -a option\n");
		exit(1);
	    }
	    cmd->autoStart = 1;
	    break;
	  case 'c':  /* Keep one copy of C and U bits */
	    if (!optarg)
		goto usage;
	    cmd->cfilename = optarg;
	    cmd->cbits = 1;
	    break;
	  case 'C':  /* Continuous acquisition of C & U bits */
	    cmd->cbits = 2;
	    if (cmd->encoding != -1) {
		fprintf(stderr,"The -C and -e options are mutually exclusive.\n");
		exit(1);
	    }
	    if (cmd->precision != -1) {
		fprintf(stderr,"The -C and -p options are mutually exclusive.\n");
		exit(1);
	    }
	    cmd->encoding = (int)NA_ENCODING_CONTROL;
	    cmd->precision = 32;
	    break;
	  case 'd':
	    if (!optarg)
		goto usage;
	    SetDebug(optarg);
	    break;
	  case 'e':
	    if (!optarg)
		goto usage;
	    if (cmd->encoding == (int)NA_ENCODING_CONTROL) {
		fprintf(stderr,"The -C and -e options are mutually exclusive.\n");
		exit(1);
	    }
	    if ((*optarg == 'l')||(*optarg == 'L'))
		cmd->encoding = (int)NA_ENCODING_LINEAR;
	    else if ((*optarg == 'i') || (*optarg == 'f') || (*optarg=='I') ||
		     (*optarg == 'F'))
		cmd->encoding = (int)NA_ENCODING_IEEE;
	    else if ((*optarg == 'u')||(*optarg == 'U'))
		cmd->encoding = (int)NA_ENCODING_ULAW;
	    else if ((*optarg == 'a')||(*optarg == 'A'))
		cmd->encoding = (int)NA_ENCODING_ALAW;
	    else {
		fprintf(stderr,"Encoding must be LINEAR,IEEE,ULAW, or ALAW\n");
		exit(1);
	    }
	    if ((cmd->encoding != NA_ENCODING_LINEAR) && (cmd->precision != -1)) {
		fprintf(stderr,"Precision (-p) can only be specified for linear encoding\n");
		exit(1);
	    }
	    break;
	  case 'f':  /* File format */
	    if (!optarg)
		goto usage;
	    cmd->format = optarg;
	    break;
#ifdef RECORD
	  case 'i': /* Input source */
	    if (!optarg)
		goto usage;
	    if ((*optarg == 'a') || (*optarg == 'A') || (*optarg == 'X') ||
		(*optarg == 'x'))
		cmd->source = DL_ISRC_AES;
	    else if ((*optarg == 'f') || (*optarg == 'F'))
		cmd->source = DL_ISRC_FIBER;
	    else if ((*optarg == 'r') || (*optarg == 'R') || (*optarg == 's') 
		     || (*optarg == 'S'))
		cmd->source = DL_ISRC_RCA;
	    else if ((*optarg == 'l') || (*optarg == 'L'))
		cmd->source = DL_ISRC_ALL;
	    else {
		fprintf(stderr,"Input source must be AES, RCA, FIBER, or LIVE\n");
		exit(1);
	    }
	    break;
#else
	  case 'S': /* Sampling rate on DAT */
	    if (!optarg)
		goto usage;
	    cmd->clock = NA_CLOCK_INTERNAL;
	    cmd->master = 0;
	    while (*optarg) {
		if ((*optarg == 'a') || (*optarg == 'A') || (*optarg == 'X') ||
		    (*optarg == 'x')) {
		    cmd->source = DL_ISRC_AES;
		    cmd->clock = NA_CLOCK_INPUT;
		}
		else if ((*optarg == 'f') || (*optarg == 'F')) {
		    cmd->source = DL_ISRC_FIBER;
		    cmd->clock = NA_CLOCK_INPUT;
		}
		else if ((*optarg == 'r') || (*optarg == 'R') || (*optarg == 's') 
			 || (*optarg == 'S')) {
		    cmd->source = DL_ISRC_RCA;
		    cmd->clock = NA_CLOCK_INPUT;
		}
		else if ((*optarg == 'E') || (*optarg == 'e')) { 
		    cmd->clock = NA_CLOCK_EXTERNAL;
		}
		else if ((*optarg == 'G') || (*optarg == 'g')) { 
		    cmd->master = 1;
		}
		else if ((*optarg == 'O') || (*optarg == 'o')) { 
		    cmd->master = 1;
		}
		else
		    break;
		optarg++;
	    }
	    if ((cmd->clock == NA_CLOCK_EXTERNAL) && (cmd->master == 1)) {
		fprintf(stderr,"Cannot both generate and receive clock from external I/O.\n");
		exit(1);
	    }
	    {
#if 0
		unsigned int32 extRate = atol(optarg);
		switch (extRate) {
		  case 44100:
		  case 48000:
		  case 32000:
		    cmd->externalRate = extRate;
		    break;
		  default:
		    fprintf(stderr,
"DAT rate (-S) must be 32000,44100, 48000, optionally prefixed by E,S,A,F and/or G.\n");
		    exit(1);
		}
#else
                cmd->externalRate = atol(optarg);
#endif
	    }
	    break;
#endif
#ifdef RECORD
	  case 'n':  /* Number of output samples to record */
	    if (!optarg)
		goto usage;
	    cmd->nsamples = atol(optarg);
	    if (cmd->nsamples <= 0) {
		fprintf(stderr,"Bad number of samples to record: %ld\n",
			(long)cmd->nsamples);
		exit(1);
	    }
	    break;
#endif
	case 'm':  /* output channel control */
	  if (!optarg)
	    goto usage;
	  switch (*optarg) {
	  case 'l':
	  case 'L':
	    out_mode = NA_CHANNELS_LEFT;
	    break;
	  case 'r':
	  case 'R':
	    out_mode = NA_CHANNELS_RIGHT;
	    break;
	  case 's':
	  case 'S':
	    out_mode = NA_CHANNELS_STEREO;
	    break;
	  default:
	    fprintf(stderr,"Invalid channel specifier: %s\n",optarg);
	    exit(1);
	  }
	  break;
	  
	case 'o':  /* Channels control */
	    if (!optarg)
		goto usage;
	    switch (*optarg) {
	      case 's':
	      case 'S':
		cmd->channels = NA_CHANNELS_STEREO;
		break;
#ifndef RECORD
	      case 'm':
	      case 'M':
		cmd->channels = NA_CHANNELS_MONO;
		break;
#endif
	      case 'l':
	      case 'L':
		cmd->channels = NA_CHANNELS_LEFT;
		break;
	      case 'r':
	      case 'R':
		cmd->channels = NA_CHANNELS_RIGHT;
		break;
	      default:
		fprintf(stderr,"Invalid channel specifier: %s\n",optarg);
#ifdef RECORD
		fprintf(stderr,"   Valid options to -o are: left, right, stereo.\n");
#else
		fprintf(stderr,"   Valid options to -o are: left, right, mono, stereo.\n");
#endif
		exit(1);
	    }
	    break;
#ifndef RECORD
	  case 'r':
	    if (!optarg)
		goto usage;
	    sep = strchr(optarg,':');
	    if (sep == 0)
		sep = strchr(optarg,'-');

	    if (sep == optarg)
		cmd->seek = 0;
	    else {
		cmd->seek = atol(optarg);
		if (cmd->seek < 0) {
		    fprintf(stderr,"Bad range specifier (-r): %s\n",optarg);
		    exit(1);
		}
	    }

	    if ((sep != 0) && (sep[1] != 0)) {
		sep++;
		if (*sep == '+')
		    cmd->nsamples = atol(sep+1);
		else
		    cmd->nsamples = atol(sep)-cmd->seek+1;

		if (cmd->nsamples < 0) {
		    fprintf(stderr,"Bad range specifier (-r): %s\n",optarg);
		    exit(1);
		}
	    }
	    break;
#endif
	  case 'p':
	    if (!optarg)
		goto usage;
	    if (cmd->encoding == NA_ENCODING_CONTROL) {
		fprintf(stderr,"The -C and -p options are mutually exclusive.\n");
		exit(1);
	    }
	    if ((cmd->encoding != NA_ENCODING_LINEAR) && (cmd->encoding != -1)) {
		fprintf(stderr,"Precision (-p) can only be specified for linear encoding\n");
		exit(1);
	    }
	    cmd->precision = atoi(optarg);
	    if ((cmd->precision < 4) || (cmd->precision > 32) ||
		(cmd->precision % 4)) {
		fprintf(stderr,"Data precision (-p) must be 4,8,12,16,20,24,28 or 32\n");
		exit(1);
	    }
	    break;
	  case 'P':  /* Position to given sample number before recording */
	    if (!optarg)
		goto usage;
	    if (getenv("DL_RC") == NULL) {
		fprintf(stderr,"DL_RC environment variable must be set to use -p option\n");
		exit(1);
	    }
	    cmd->position = atol(optarg);
	    if (cmd->position < 0) {
		fprintf(stderr,"Bad sample number to begin recording: %ld\n",
			(long)cmd->position);
		exit(1);
	    }
	    cmd->autoStart = 1;   /* -P implies -a */
	    break;
#ifdef RECORD
	  case 'q':  /* Skip silence */
	    cmd->skipSilence = True;
	    break;
#endif /* RECORD */
#ifndef RECORD
	  case 'R':  /* Playback repetitions */
	    if (!optarg)
		goto usage;
	    cmd->repeats = atoi(optarg);
	    if (cmd->repeats < 1) {
		fprintf(stderr,"Number of repetitions must be >= 1\n");
		exit(1);
	    }
	    break;
#endif
	  case 's':  /* Sampling rate of resulting file */
	    if (!optarg)
		goto usage;
	    if (atof(optarg) <= 0) {
		fprintf(stderr,"File sampling rate must be >0\n");
		exit(1);
	    }
	    cmd->sampleRate = atof(optarg);
	    break;
	  case 't':  /* Duration of recording in seconds */
	    if (!optarg)
		goto usage;
	    cmd->duration = atof(optarg);
	    if (cmd->duration < 0) {
		fprintf(stderr,"Bad value of recording duration: %f\n", cmd->duration);
		exit(1);
	    }
	    break;
	  case 'u':
	    if (!optarg)
		goto usage;
	    cmd->unit = optarg;
	    break;
	  default:
	  usage:
#ifdef RECORD
    	    fprintf(stderr,"Usage: %s [options] [file]\n",argv[0]);
#else /* RECORD */
            fprintf(stderr,"Usage: %s [options] [file [file ...]]\n",argv[0]);
#endif /* RECORD */
            fprintf(stderr,"	-a	auto start/stop DAT machine\n");
#ifndef RECORD
            fprintf(stderr,"	-A	Generate control bits for Pro standard\n");
	    fprintf(stderr,"                Default: Generate control and user bits for S/P DIF\n");
	    fprintf(stderr,"	-c file read the DAT control bits from file\n");
	    fprintf(stderr,"        -C      read the control bits with the data\n");
#else /* RECORD */
            fprintf(stderr,"	-c file store the DAT control bits in file\n");
	    fprintf(stderr,"        -C      store the control bits with the data\n");
	    fprintf(stderr,"                Default: Discard control and user bits\n");
#endif /* RECORD */
            fprintf(stderr,"	-e enc  specify data encoding\n");
	    fprintf(stderr,"		Default: linear\n");
	    fprintf(stderr,"	-f form specify file format\n");
	    fprintf(stderr,"                Default: raw\n");
#ifdef RECORD
            fprintf(stderr,"	-i src  specify input source\n");
	    fprintf(stderr,"                Default: SPDIF input\n");
#endif /* RECORD */
#ifdef RECORD
            fprintf(stderr,"	-n nn   record nn samples\n");
	    fprintf(stderr,"	-o chan channels to record from: left,right, or stereo\n");
#else
            fprintf(stderr,"	-o chan channels to output on: left,right,mono, or stereo\n");
#endif
            fprintf(stderr,"                Default: stereo\n");
	    fprintf(stderr,"	-p nn	precision of data in bits/sample\n");
/*	    fprintf(stderr,"	-P nn   position DAT to sample nn before beginning\n"); */
#ifdef RECORD
            fprintf(stderr,"	-q	skip silence before beginning\n");
#else
            fprintf(stderr,"	-r rng  playback given sample number range\n");
	    fprintf(stderr,"	-R nn	repeat passage nn times\n");
#endif
            fprintf(stderr,"	-s nn   sampling rate of file data\n");
	    fprintf(stderr,"                Default: same as DAT sampling rate\n");
#ifndef RECORD
            fprintf(stderr,"	-S nn	sampling rate of DAT recording\n");
	    fprintf(stderr,"                Default: 48,000 samples/second\n");
#endif
#ifdef RECORD
            fprintf(stderr,"	-t nn   duration of recording in seconds\n");
	    fprintf(stderr,"                Default: record until interrupted\n");
#else /* RECORD */
            fprintf(stderr,"	-t nn   duration of playback in seconds\n");
	    fprintf(stderr,"                Default: playback entire file\n");
#endif /* RECORD */
            fprintf(stderr,"	-u host:unit\n");
	    fprintf(stderr,"		Connect to DAT-Link unit on host\n");
	    fprintf(stderr,"	file    File for I/O or standard I/O if missing\n");
	    exit(1);
	}

    /* Process exclusive and default arguments */
    if ((cmd->nsamples != -1) && (cmd->duration != -1)) {
	fprintf(stderr,"Error: the -n and -t options are mutually exclusive\n");
	exit(1);
    }


    // added by ISIP to control input and output channel control
    //
    if ((cmd->channels == NA_CHANNELS_MONO) ||
	(cmd->channels == NA_CHANNELS_LEFT) ||
	(cmd->channels == NA_CHANNELS_RIGHT)) {
      out_mode = NA_CHANNELS_STEREO;
    }
      
    /* Process remaining file names */
    while (optind < argc)
	/* File name on command line is output file */
	cmd->names[cmd->numfiles++] = argv[optind++];
}
