/* $Id: vsyslog.c,v 1.4 1995/10/17 22:15:53 bst Exp $
 *
 * Copyright 1993 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Tue Jun 29 21:35:22 EDT 1993
 *
 * Revision History: $Log: vsyslog.c,v $
 * Revision 1.4  1995/10/17  22:15:53  bst
 * Ignore return value from syslog() (some machines declare it as void)
 *
 * Revision 1.3  1993/08/27  00:42:38  bst
 * Use new HAS_* defines.
 * Removed system declarations.
 * Use NEEDS_VA
 *
 * Revision 1.2  1993/07/08  18:37:11  bst
 * Undefine 'const' if not STDC.
 *
 * Revision 1.1  1993/06/30  01:35:46  bst
 * Initial revision
 *
 */
#define NEEDS_VA
#include "sysdefs.h"
int junk_vsyslog = 0;	/* To suppress "empty file" warnings */

#if defined(HAS_syslog)&&!defined(HAS_vsyslog)
#ifdef HAS_syslog_h
#include <syslog.h>
#endif /* HAS_syslog_h */

#include "support.h"

int vsyslog (priority, format, ap)
int priority;
const char *format;
va_list ap;
{
    static char syslogbuf[500];
#ifdef HAS_vsprintf
    vsprintf(syslogbuf,format,ap);
#else /* HAS_vsprintf */
    FILE b;
    int ret;
    b._flag = _IOWRT|_IOSTRG;
    b._ptr = syslogbuf;
    b._base = syslogbuf;
    b._cnt = sizeof(syslogbuf);
    ret = _doprnt(format,ap,&b);
    fputc('\0', &b);
#endif /* !HAS_vsprintf */
    (void)syslog(priority,"%s",syslogbuf);
    return 0;
}
#endif /* HAS_syslog && !HAS_vsyslog */
