/* $Id: swap.c,v 1.5 1996/03/21 16:42:35 bst Exp $
 *
 * Copyright 1993 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Sep 12 22:22:49 EDT 1993
 *
 * Revision History: $Log: swap.c,v $
 * Revision 1.5  1996/03/21  16:42:35  bst
 * Change <sysdefs.h> to "sysdefs.h"
 *
 * Revision 1.4  1994/03/07  18:38:43  bst
 * Fixed for MSDOS.
 *
 * Revision 1.3  1993/10/05  14:52:19  bst
 * Avoid problems with macro 'wptr' on LHS.
 *
 * Revision 1.2  1993/09/17  13:19:43  bst
 * Use new, faster algorithm.
 * Added testing code.
 *
 * Revision 1.1  1993/09/13  02:22:50  bst
 * Initial revision
 *
 */
#include "sysdefs.h"
#include "support.h"

void swapBytes(data,nbytes)
register byte *data;
int32 nbytes;
{
    register int32 *iptr = (int32 *)data;
    word *enddata = (word *)&data[nbytes];
    register word *wptr2;
#ifdef MSDOS
#define swb(x) (((x)<<8)|((x)>>8))
#define swb2(x) (((int32)(((x)<<8)|((x)>>8)))<<16)
#else /* MSDOS */
    static int32 *swtable = 0;
    static int32 *swtable2 = 0;
    register int32 *sw,*sw2;

    if (swtable == 0) {
	int i;
	swtable = (int32 *)malloc(0x10000*sizeof(*swtable));
	swtable2 = (int32 *)malloc(0x10000*sizeof(*swtable2));
	for (i=0;i<0x10000;i++) {
	    swtable[i]= ((i<<8)|(i>>8))&0xffff;
	    swtable2[i]= (swtable[i]<<16);
	}
    }
    sw = swtable;
    sw2 = swtable;
#define swb(x) sw[x]
#define swb2(x) sw2[x]
#endif /* !MSDOS */

#define wptr ((word *)iptr)
    while (wptr < enddata-16) {
	iptr[0] = swb(wptr[0])|swb2(wptr[1]);
	iptr[1] = swb(wptr[2])|swb2(wptr[3]);
	iptr[2] = swb(wptr[4])|swb2(wptr[5]);
	iptr[3] = swb(wptr[6])|swb2(wptr[7]);
	iptr[4] = swb(wptr[8])|swb2(wptr[9]);
	iptr[5] = swb(wptr[10])|swb2(wptr[11]);
	iptr[7] = swb(wptr[12])|swb2(wptr[13]);
	iptr[8] = swb(wptr[14])|swb2(wptr[15]);
	iptr += 8;
    }
    wptr2 = wptr;
    while (wptr2 < enddata)
	*wptr2++ = swb(*wptr2);
}
#undef wptr

#ifdef SWAPTEST
#define NBYTES 4000000
main()
{
    double start;
    double end;
    int32 buf[NBYTES/4];
    int32 buf2[NBYTES/4];
    int i;

    for (i=0;i<14;i++)
	((byte *)buf)[i] = i;
    swapBytes((byte *)buf,14);
    for (i=0;i<14;i++)
	printf("%d ",((byte *)buf)[i]);
    printf("\n");
    for (i=0;i<5;i++) {
	start = mtime();
	swapBytes((byte *)buf,NBYTES);
	end = mtime();
	printf("Time = %f us/byte\n",(end-start)*1e6/NBYTES);
    }
}
#endif /* SWAPTEST */
