/* $Id: strcasecmp.c,v 1.8 1995/07/29 00:03:23 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Nov 10 23:03:58 EST 1991
 *
 * Revision History: $Log: strcasecmp.c,v $
 * Revision 1.8  1995/07/29  00:03:23  bst
 * Fixed declaration of strcasecmp.
 *
 * Revision 1.7  1995/02/21  18:26:00  bst
 * Handled unsinged args to strncasecmp()
 *
 * Revision 1.6  1994/03/07  18:38:17  bst
 * Made strncasecmp() 3rd arg size_t.
 *
 * Revision 1.5  1993/08/27  00:33:45  bst
 * Use HAS_* defines.
 * include sysdefs.h
 * Made str*casecmp() args const.
 *
 * Revision 1.4  1992/02/15  19:51:48  bst
 * Fixed bug in strncasecmp()
 *
 * Revision 1.3  1991/12/06  18:41:57  bst
 * Removed const qualifiers.
 *
 * Revision 1.2  1991/12/06  06:03:17  bst
 * Renamed dat_strcase*cmp -> strcase*cmp
 *
 * Revision 1.1  1991/11/11  04:04:03  bst
 * Initial revision
 *
 */
#include "sysdefs.h"
#define tolower(x) (((x>='A')&&(x<='Z'))?(x-'A'+'a'):x)

#ifndef HAS_strcasecmp
int strcasecmp(s1,s2)
const char *s1;
const char *s2;
{
    while (*s1 && *s2) {
	if (tolower(*s1) < tolower(*s2))
	    return -1;
	else if (tolower(*s1) > tolower(*s2))
	    return 1;
	s1++; s2++;
    }
    if (*s1)
	return 1;
    else if (*s2)
	return -1;
    return 0;
}
#endif

#ifndef HAS_strncasecmp
int strncasecmp(s1,s2,narg)
const char *s1;
const char *s2;
size_t narg;
{
    int n = narg;   /* In case narg is unsigned */
    while (*s1 && *s2 && n--) {
	if (tolower(*s1) < tolower(*s2))
	    return -1;
	else if (tolower(*s1) > tolower(*s2))
	    return 1;
	s1++; s2++;
    }
    if (n<=0)
	return 0;
    if (*s1)
	return 1;
    else if (*s2)
	return -1;
    return 0;
}
#endif
