/* $Id: spw_signal.h,v 1.3 1993/06/23 20:10:15 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Thu Jan 23 23:52:33 EST 1992
 *
 * Revision History: $Log: spw_signal.h,v $
 * Revision 1.3  1993/06/23  20:10:15  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.2  1993/04/21  02:12:10  bst
 * Rename complex as 'spw_complex' to avoid conflict with Borland math.h
 *
 * Revision 1.1  1992/01/24  04:52:38  bst
 * Initial revision
 *
 */
/*
 * FILE:  		u_sigdecl.h
 * AUTHOR:		Douglas Selph
 * DATE:		July 1989
 * DESCRIPTION:
 */

#define MAGIC 0x15
#define MAX_REV_STR 12

#define TYPE_UNDEFINED 0
#define TYPE_INVALID 1
#define TYPE_INTEGER 2
#define TYPE_DOUBLE 3
#define TYPE_FXDPT 4
#define TYPE_LOGICAL 5
#define TYPE_STRING 6
#define TYPE_FLOAT 7
#define TYPE_CLASS_MASK 0x1F
#define TYPE_IS_DOUBLE(type) (((type) & TYPE_CLASS_MASK) == TYPE_DOUBLE)
#define TYPE_IS_FXDPT(type) (((type) & TYPE_CLASS_MASK) == TYPE_FXDPT)

#define TYPE_REAL 0x00
#define TYPE_COMPLEX 0x20
#define TYPE_RC_MASK 0x20
#define TYPE_IS_COMPLEX(type) (((type) & TYPE_RC_MASK) == TYPE_COMPLEX)

/*
 *   This is revision 7: the most current and up-to-date
 *   signal format for the 2.6 release.
 */
struct spw_signal
{
  char revision[MAX_REV_STR];	/* revision number of signal */
  int magic;    		/* identifies signal file for what it is */
  /*
   *  Standard data:
   */
  double starttime;	/* Starting time for the signal */
  double samp_freq;	/* Sampling frequency for the signal */
  int32 num_of_pts;      /* number of points used in array (sig's can grow & shrink) */
  int32 alloc_size;	/* size of malloc'ed array */

  char *filename;	/* recorded file that structure came from */
  char *comment;        /* malloc'ed comment string */
  /*
   *  Type: What is the declared type of the points?
   *    Can be TYPE_COMPLEX or TYPE_REAL in combination
   *     with TYPE_DOUBLE, TYPE_LOGICAL, TYPE_INTEGER,
   *       TYPE_FXDPT, or TYPE_FLOAT.
   */
  unsigned char type;	/* TYPE_REAL or TYPE_COMPLEX only */
  /*
   *  Additional arrays:
   */
  double *vals;         /* malloc'ed array of points for reals */
  double *imag;		/* imagniray parallel array */
  double *mag;		/* parallel magnitude response form */
  double *phase;	/* parallel angle of mag/phase form */
  unsigned short *fxvals;/* array of real/mag fixed point format numbers */
  unsigned short *fximag;/* array of imag/phase fixed point format numbers */
  /*
   *  Size Data:
   */
  struct size_data
  {
    struct int_data
    {
      int numbits;	/* for INTEGER format */
      int Signed;	/* INTEGER: TRUE if signed, FALSE is unsigned */
    } integer;
    struct {
	short numbits;
	short exponent;
	short format;
    } fixed;
    struct {
	double real;
	double imag;
    } threshhold;  /* for LOGICAL format */
  } sdata;
  /*
   *  Vector information:
   */
  struct vector_data
  {
    int type;		/* INTERLACED or END_TO_END */
    int vector_len;
    int32 num_vectors;
  } vector;
  /*
   *  Flags:
   *   Note: it was necessary to get rid of the bitfields
   *    so that the structure would be compatable with
   *    the C30 compliler on both APOLLO & SUN.
   */
  struct signal_flags
  {
    unsigned int vector : 1;	     /* set if vector */
    unsigned int is_mag_phase : 1;   /* if set, complex signal is in mag/phase form */
    unsigned int mag_in_degrees : 1; /* if set, mag/phase in degrees, otherwise radians */
    unsigned int mag_conversion : 1; /* if set, converted from mag/phase to complex */
    unsigned int mag_ri_changed : 1; /* if set, mag/phase's real/imag changed */
    unsigned int fixed_conversion : 1; /* if set, converted from fixed arrays to double */
    unsigned int normalize : 1;      /* if set, normalize before storage */
    unsigned int packed : 1;	     /* if set, then the stored array is packed */
  } flag;
};

struct spw_signal_rev4
{
  char revision[12];	/* revision number of signal */
  int magic;    	/* identifies signal file for what it is */
  /*
   *  Standard data:
   */
  double *vals;         /* malloc'ed array of points for reals */
  double starttime;	/* Starting time for the signal */
  double samp_freq;	/* Sampling frequency for the signal */
  int32 num_of_pts;      /* number of points used in array (sig's can grow & shrink) */
  int32 alloc_size;	/* size of malloc'ed array */

  char *filename;	/* recorded file that structure came from */
  char *comment;        /* malloc'ed comment string */
  /*
   *  Type: What is the declared type of the points?
   *  Size: For real type, what size do we treat each point?
   */
  int type;	/* TYPE_REAL, TYPE_COMPLEX, TYPE_STRING */
  int size;     /* SIZE_DOUBLE, SIZE_INTEGER, SIZE_LOGICAL, SIZE_FIXED */
  /*
   *  Additional arrays:
   */
  double *imag;		/* imagniray parallel array */
  double *mag;		/* parallel magnitude response form */
  double *phase;	/* parallel angle of mag/phase form */
  char **strs;		/* signal is an array of strings */
  /*
   *  Size Data:
   */
  struct size_data_rev4
  {
    struct int_data_rev4
    {
      int numbits;	/* for INTEGER format */
      int Signed;	/* INTEGER: TRUE if signed, FALSE is unsigned */
    } integer;
    struct fixed_data_rev4
    {
      int numbits;	/* for FIXED format */
      int exp;		/* for FIXED format */
      int Signed;	/* FIXED: TRUE if signed, FALSE is unsigned */
    } fixed;
    struct spw_complex {
	double re;
	double im;
	} threshhold;  /* for LOGICAL format */
  } sdata;
  /*
   *  Vector information:
   */
  struct vector_data_rev4
  {
    int type;		/* INTERLACED or END_TO_END */
    int vector_len;
    int32 num_vectors;
  } vector;
  /*
   *  Flags:
   *   Note: it was necessary to get rid of the bitfields
   *    so that the structure would be compatable with
   *    the C30 compliler on both APOLLO & SUN.
   */
  struct signal_flags_rev4
  {
    unsigned int vector : 1;	     /* set if vector */
    unsigned int is_mag_phase : 1;   /* if set, complex signal is in mag/phase form */
    unsigned int mag_in_degrees : 1; /* if set, mag/phase in degrees, otherwise radians */
    unsigned int mag_conversion : 1; /* if set, converted from mag/phase to complex */
    unsigned int mag_ri_changed : 1; /* if set, mag/phase's real/imag changed */
    unsigned int normalize : 1;      /* if set, normalize before storage */
  } flag;
};
