/* $Id: sppack.c,v 1.22 1996/03/21 16:42:28 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Nov 3 20:42:35 EST 1991
 *
 * Revision History: $Log: sppack.c,v $
 * Revision 1.22  1996/03/21  16:42:28  bst
 * Made some fns static
 *
 * Revision 1.21  1994/04/25  20:31:09  bst
 * Fixed arg types for *_wrheader(), *_write*()
 *
 * Revision 1.20  1993/11/19  03:22:26  bst
 * Removed fcntl.h
 *
 * Revision 1.19  1993/08/27  00:36:54  bst
 * Use NEED_TIME.
 *
 * Revision 1.18  1993/08/10  02:44:11  bst
 * Handle byte-swapped header.
 * Moved abs() macro to support.h
 *
 * Revision 1.17  1993/07/05  23:54:42  bst
 * Use time_t for time type.
 *
 * Revision 1.16  1993/06/23  20:10:15  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.15  1993/05/18  19:45:48  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.14  1993/04/22  03:25:13  bst
 * Don't redefine abs()
 * Added include of formats.h
 *
 * Revision 1.13  1993/02/07  19:37:41  bst
 * *** empty log message ***
 *
 * Revision 1.12  1992/05/10  19:02:26  bst
 * Added encoding, precisin.
 *
 * Revision 1.11  1992/04/09  17:59:04  bst
 * Changed strings.h to string.h
 *
 * Revision 1.10  1992/04/07  22:57:01  bst
 * Use DebugCheck() instead of Debug() to avoid format warning.
 *
 * Revision 1.9  1992/01/22  21:07:29  bst
 * Use 'channels' instead of 'left','right'
 *
 * Revision 1.8  1992/01/19  04:28:06  bst
 * Removed sppack_seek() - can use SampFile_seek()
 * Added setting of this->sampleSize
 *
 * Revision 1.7  1991/12/10  22:12:21  bst
 * Use currentSample to keep track of current sample number position.
 *
 * Revision 1.6  1991/12/06  06:01:48  bst
 * Added char * coercions to read(), write().
 *
 * Revision 1.5  1991/11/11  04:28:31  bst
 * Use new Debug() procedure.
 * Added abs() macro.
 * Remove debug message from wrheader.
 *
 * Revision 1.4  1991/11/08  21:30:46  bst
 * Added nsamples argument to wrheader()
 *
 * Revision 1.3  1991/11/07  14:53:41  bst
 * Changed check for stereo.
 *
 * Revision 1.2  1991/11/06  16:42:15  bst
 * Use 'unsigned int' instead of 'u_int'
 *
 * Revision 1.1  1991/11/04  01:47:10  bst
 * Initial revision
 *
 */
#define NEEDS_TIME
#include <stdio.h>
#include <string.h>
#include "sysdefs.h"
#include "sampfile.h"
#include "debug.h"
#include "formats.h"
#include "support.h"

typedef struct {
    char cs1[80];
    char cs2[80];
    char cmd[80];
    short domain,flen;
    float srate;
    short unused[2];
    short magic;
    short type;
    /* -1010 Module */
    short resolution;
    short companding;
    char lstr1[80];
    char lstr2[80];
    char lstr3[80];
#define DLMAGIC 4567
    short dl_magic;
    short left;
    short right;
    short unused2[3];
} SPPack;

static int sppack_rdheader(this)
SampFile *this;
{
    SPPack hdr;
    this->precision = 16;
    this->encoding = 0;
    if (read(this->fd,(char *)&hdr,sizeof(hdr)) != sizeof(hdr)) {
	NALog(LOG_ERR,"Unable to read SPPACK header from %s: %s\n",
	      this->name, NAsyserr());
	exit(5);
    }
    if (hdr.magic != 16579) {
	/* Try swapping the bytes */
	SwapShort(&hdr.magic);
	if (hdr.magic != 16579) {
	    NALog(LOG_ERR,"%s is not an SPPACK file.\n",this->name);
	    exit(5);
	}
	SwapShort(&hdr.domain);
	SwapShort(&hdr.flen);
	SwapLong((int32 *)&hdr.srate);	/* Floating point format may be wrong! */
	SwapShort(&hdr.type);
	SwapShort(&hdr.resolution);
	SwapShort(&hdr.companding);
	SwapShort(&hdr.dl_magic);
	SwapShort(&hdr.left);
	SwapShort(&hdr.right);
    }
    
    if (DebugCheck("libdatlink.readheader",3)) {
	Debug("libdatlink.readheader",3,"Read SPPACK header\n");
	Debug("libdatlink.readheader",3,"cs1=%s\n",hdr.cs1);
	Debug("libdatlink.readheader",3,"cs2=%s\n",hdr.cs2);
	Debug("libdatlink.readheader",3,"cmd=%s\n",hdr.cmd);
	Debug("libdatlink.readheader",3,"domain=%d\n",hdr.domain);
	Debug("libdatlink.readheader",3,"flen=%d\n",hdr.flen);
	Debug("libdatlink.readheader",3,"srate=%f\n",hdr.srate);
	Debug("libdatlink.readheader",3,"type=%d\n",hdr.type);
    }
    if (abs(hdr.type)/1000 != 1) {
	NALog(LOG_ERR,"Cannot read SPPACK file of type %d\n",hdr.type);
	exit(5);
    }
    if (this->srate < 0)
	this->srate = hdr.srate;
    if (this->channels == -1) {
	if (hdr.dl_magic == DLMAGIC)
	    this->channels = hdr.left|(hdr.right<<1);
	else
	    this->channels = 0;
    }
    this->sampleSize = this->precision*((this->channels==3)?2:1);
    return 0;
}

static int sppack_wrheader(this,nsamples)
SampFile *this;
unsigned int32 nsamples;
{
#ifdef PRAGMA_UNUSED
#pragma unused(nsamples)
#endif /* PRAGMA_UNUSED */
    SPPack hdr;
    time_t t;

    if (this->precision == -1)
	this->precision = 16;
    if (this->encoding == -1)
	this->encoding = 0;
    if ((this->encoding != 0) || (this->precision != 16)) {
	NALog(LOG_ERR,"Sorry, only 16-bit, linear supported for SPPACK files\n");
	return -1;
    }

    bzero((char *)&hdr,sizeof(hdr));
    time(&t);
    sprintf(hdr.cs1,"Recorded via DAT-Link on %s",ctime(&t));
    this->precision = 16;
    if (this->channels == 3) {
	strcpy(hdr.cs2,"Stereo");
	this->sampleSize = 2*this->precision;
    }
    else {
	strcpy(hdr.cs2,(this->channels&1)?"Left Channel":"Right Channel");
	this->sampleSize = this->precision;
    }
    strncpy(hdr.cmd,this->cmd,80);

    /* Always store in net order */
    hdr.type = htons(-1010);
    hdr.domain = htons(1);
    *(int32 *)&hdr.srate = htonl(*(int32 *)&this->srate);
    hdr.flen = htons(2000);
    hdr.magic = htons(16579);
    hdr.resolution = htons(16);
    hdr.companding = htons(1);
    hdr.dl_magic = htons(DLMAGIC);
    hdr.left = htons(this->channels&1);
    hdr.right = htons(this->channels>>1);

    if (write(this->fd,(char *)&hdr,sizeof(hdr)) != sizeof(hdr)) {
	NALog(LOG_ERR,"Unable to write SPPACK header to %s\n",this->name);
	exit(5);
    }
    return 0;
}

void sppack_construct(this)
SampFile *this;
{
    this->wrheader = sppack_wrheader;
    this->rdheader = sppack_rdheader;
    this->headerLength = 512;
}
