/* $Id: sampio.c,v 1.10 1996/03/21 18:29:39 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Feb 16 23:44:35 EST 1992
 *
 * Revision History: $Log: sampio.c,v $
 * Revision 1.10  1996/03/21  18:29:39  bst
 * Added include of debug.h
 *
 * Revision 1.9  1996/03/21  16:41:41  bst
 * Check for out of memory after realloc.
 *
 * Revision 1.8  1993/10/26  16:16:07  bst
 * Added coercions for GCC 2.5.0
 *
 * Revision 1.7  1993/07/08  18:36:43  bst
 * Use SamplesToBytes(), BytesToSamples() macros.
 *
 * Revision 1.6  1993/06/23  20:10:15  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.5  1993/06/01  02:45:36  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.4  1993/04/12  02:14:32  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.3  1992/11/09  04:48:24  bst
 * Prevent write routine from writing partial samples.
 *
 * Revision 1.2  1992/05/12  18:55:12  bst
 * Use 'sampleSize' to convert between bytes and samples.
 *
 * Revision 1.1  1992/02/17  04:45:04  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include "sysdefs.h"
#include "sampfile.h"
#include "support.h"
#include "debug.h"

/* Sample I/O routines
 *
 * Routines are named as follows:
 *
 * samp_read_nn_b, samp_write_nn_b
 *
 * nn is number of bits/sample, or flt, or dbl
 * b is B or L for Big-Endian or Little-Endian
 */

/* Big-Endian 16 bit write/read routines */
int32 samp_write_16_B(this,buf,nbytes)
SampFile *this;
const byte *buf;
int32 nbytes;
{
    int32 numSamples = BytesToSamples(nbytes,this->sampleSize);
    /* Never write a partial sample */
    if ((this->sampleSize%8) == 4)
	numSamples = numSamples & ~1;
    nbytes = SamplesToBytes(numSamples,this->sampleSize);
    this->currentSample += numSamples;
    return longwrite(this->fd,(char *)buf,(unsigned int32)nbytes);
}

int32 samp_read_16_B(this,buf,nbytes)
SampFile *this;
byte *buf;
int32 nbytes;
{
    int32 numSamples = BytesToSamples(nbytes,this->sampleSize);
    nbytes = SamplesToBytes(numSamples,this->sampleSize);
    this->currentSample += numSamples;
    return longread(this->fd,(char *)buf,(unsigned int32)nbytes);
}

int32 samp_read_N_B(this,buf,nbytes)
SampFile *this;
byte *buf;
int32 nbytes;
{
    int bytesPerSample = (this->sampleSize+7)/8;
    int32 bytesToRead = (nbytes/2)*bytesPerSample;
    int32 bytesRead,samplesRead;
    int mask;
    register short *sptr;
    static unsigned char *tptr,*tbuf = 0;
    static size_t tbufLength = 0;
    int32 i;

    if (this->sampleSize < 16)
	mask = ~(1<<(16-this->sampleSize));
    else
	mask = 0xffff;

    if (bytesToRead > tbufLength) {
	tbufLength = bytesToRead;
	if (tbuf)
	    tbuf = (unsigned char *)realloc(tbuf,tbufLength);
	else
	    tbuf = (unsigned char *)malloc(tbufLength);
	if (tbuf == 0) {
	    NALog(LOG_ERR,"Out of memory\n");
	    exit(1);
	}
    }
    bytesRead = longread(this->fd,(char *)tbuf,(unsigned int32)bytesToRead);
    if (bytesRead <= 0)
	return bytesRead;
    samplesRead = bytesRead/bytesPerSample;
    this->currentSample += samplesRead/((this->channels==3)?2:1);
    sptr = (short *)buf;
    tptr = tbuf;
    for (i=0;i<samplesRead;i++) {
        *sptr++ = ((tptr[0]<<8)|tptr[1])&mask;
	tptr += bytesPerSample;
    }
    return samplesRead*2;
}

int32 samp_write_16_L(this,buf,nbytes)
SampFile *this;
const byte *buf;
int32 nbytes;
{
    register word *wbuf = (word *)buf;
    register int32 i;
    int32 numSamples;

    nbytes &= ~1;
    numSamples = BytesToSamples(nbytes,this->sampleSize);
    nbytes = SamplesToBytes(numSamples,this->sampleSize);
    
    /* Swap bytes */
    for (i=0;i<nbytes/2;i++)
	wbuf[i] = ((wbuf[i]<<8)|(wbuf[i]>>8));
    this->currentSample += numSamples;
    return longwrite(this->fd,(char *)buf,(unsigned int32)nbytes);
}

int32 samp_read_16_L(this,buf,nbytes)
SampFile *this;
byte *buf;
int32 nbytes;
{
    register word *wbuf = (word *)buf;
    register int32 i;
    int32 nremain = nbytes;
    int32 nread = 0;
    int32 numSamples = BytesToSamples(nbytes,this->sampleSize);
    nbytes = SamplesToBytes(numSamples,this->sampleSize);

    while (nremain > 1) {
	int32 xfr = longread(this->fd,(char *)buf,
			     (unsigned int32)(nremain&~0x1));
	if (xfr <= 0)
	    break;
	buf += xfr;
	nremain -= xfr;
	nread += xfr;
    }

    /* Swap bytes */
    for (i=0;i<nread/2;i++)
	wbuf[i] = ((wbuf[i]<<8)|(wbuf[i]>>8));
    this->currentSample += numSamples;
    return nread;
}
