/* $Id: native.c,v 1.10 1993/04/22 03:24:11 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Nov 3 20:42:28 EST 1991
 *
 * Revision History: $Log: native.c,v $
 * Revision 1.10  1993/04/22  03:24:11  bst
 * Added include of formats.h
 *
 * Revision 1.9  1992/02/17  04:48:34  bst
 * Moved sample I/O routines to sampio.c
 *
 * Revision 1.8  1992/01/22  21:04:55  bst
 * Use 'channels' instead of 'left','right'
 *
 * Revision 1.7  1991/12/10  22:13:25  bst
 * Use currentSample to keep track of current sample number position.
 *
 * Revision 1.6  1991/12/06  18:40:55  bst
 * Remove const qualifier for arg to swap_write()
 *
 * Revision 1.5  1991/12/06  06:02:35  bst
 * Removed include of libdefs.h
 * Added char * coercions.
 *
 * Revision 1.4  1991/11/22  05:07:21  bst
 * Handle odd number of bytes in swap IO routines by returning short count.
 * Added swap_contruct() to always swap bytes.
 *
 * Revision 1.3  1991/11/08  21:29:38  bst
 * Don't include 'playrec.h'
 *
 * Revision 1.2  1991/11/04  14:14:39  bst
 * Convert to non-ANSI function headers.
 *
 * Revision 1.1  1991/11/04  01:47:10  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include "sysdefs.h"
#include "sampfile.h"
#include "formats.h"

void native_construct(this)
SampFile *this;
{
    word tmp = 0x102;
    if (*(byte *)&tmp == 0x2) {
	/* This machine is little-endian, need to swap bytes */
	this->write = samp_write_16_L;
	this->read = samp_read_16_L;
    }
}

void swap_construct(this)
SampFile *this;
{
    this->write = samp_write_16_L;
    this->read = samp_read_16_L;
}
