/* $Id: mtime.c,v 1.5 1994/03/07 18:37:20 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Sep 16 20:00:49 EDT 1992
 *
 * Revision History: $Log: mtime.c,v $
 * Revision 1.5  1994/03/07  18:37:20  bst
 * Use ftime() if available.
 *
 * Revision 1.4  1993/08/27  00:40:17  bst
 * Use NEEDS_TIME.
 * Use getclock() if system has it.
 *
 * Revision 1.3  1993/04/22  18:41:14  bst
 * Added MSDOS support.
 *
 * Revision 1.2  1993/02/18  21:38:55  bst
 * Added declaration of 'struct timezone'  (Missing under MSDOS)
 *
 * Revision 1.1  1992/09/17  00:24:45  bst
 * Initial revision
 *
 */
#define NEEDS_TIME
#include <stdio.h>
#include "sysdefs.h"
#include "support.h"

double mtime()
{
#ifdef HAS_getclock
    struct timespec t;
    getclock(1,&t);
    return t.tv_nsec/1.0e9+t.tv_sec;
#else /* HAS_getclock */
#ifndef MISSING_gettimeofday
    struct timeval rt;
    gettimeofday(&rt,0);
    return rt.tv_usec/1e6 + rt.tv_sec;
#else /* !MISSING_gettimeofday */
#ifdef HAS_ftime
    struct timeb t;
    ftime(&t);
    return t.millitm/1000.0 + t.time;
#else /* HAS_ftime */
#ifdef macintosh
    return time(0)*1.0;
#else /* macintosh */
  ERROR: No Time function available.
#endif /* !macintosh */
#endif /* !HAS_ftime */
#endif /* MISSING_gettimeofday */
#endif /* !HAS_getclock */
}
