/* $Id: maxprio.c,v 1.4 1994/07/22 16:12:42 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Sep 16 20:00:52 EDT 1992
 *
 * Revision History: $Log: maxprio.c,v $
 * Revision 1.4  1994/07/22  16:12:42  bst
 * Made maxprio() print a warning rather than error for EPERM error.
 *
 * Revision 1.3  1993/08/27  00:39:46  bst
 * Use NEEDS_TIME
 * Use HAS_setpriority instead of SETPRIORITY.
 *
 * Revision 1.2  1993/05/18  19:44:58  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.1  1992/09/17  00:24:35  bst
 * Initial revision
 *
 */

/* Set current process to maximum priority possible */
#define NEEDS_TIME	/* Really for sys/resource.h */
#include <stdio.h>
#include "sysdefs.h"
#include "support.h"
#include "debug.h"

#ifndef EPERM
#define EPERM EACCES
#endif

void maxprio()
{
#ifdef HAS_setpriority
    if (setpriority(PRIO_PROCESS,0,-20) < 0) {
	NALog(((errno == EACCES)|(errno == EPERM))?LOG_WARNING:LOG_ERR,
	      "Not able to increase process priority: %s.\n",
	      NAsyserr());
    }
#endif /* HAS_setpriority */
}
