/* $Id: longio.c,v 1.10 1996/03/19 20:53:48 eryk Exp $
 *
 * Copyright 1993 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Apr 11 21:16:15 EDT 1993
 *
 * Revision History: $Log: longio.c,v $
 * Revision 1.10  1996/03/19  20:53:48  eryk
 * removed calls to coreleft()
 *
 * Revision 1.9  1995/03/10  00:56:04  bst
 * Don't use aspiread() in longread() under DOS.
 *
 * Revision 1.8  1994/03/07  18:36:03  bst
 * Made count args unsigned.
 *
 * Revision 1.7  1993/11/19  03:22:00  bst
 * Added chk_malloc,realmalloc for all hosts.
 *
 * Revision 1.6  1993/08/27  00:40:56  bst
 * Only compile long*() if they are needed.
 * Use char* args for longmemcpy()
 *
 * Revision 1.5  1993/08/10  02:32:16  bst
 * Addec chk_*malloc().
 * Call aspiread() instead of read() from longread() under DOS.
 *
 * Revision 1.4  1993/07/06  02:04:50  bst
 * Fixed coercion on LHS.
 *
 * Revision 1.3  1993/06/23  20:09:34  bst
 * Always compile body - use macros to redefine if not needed.
 * Changed 'long' to 'int32'
 *
 * Revision 1.2  1993/04/22  18:40:45  bst
 * Use INT16 macro.
 *
 * Revision 1.1  1993/04/12  01:16:18  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include "sysdefs.h"
#include "debug.h"
#include "support.h"
#ifdef MSDOS
#include "aspi_io.h"
#endif /* MSDOS */

int junk_longio=0;	/* To avoid empty file warnings */

#if SIZEOF_INT == 2
int32 longread(fd,buf,len)
int fd;
char *buf;
unsigned int32 len;
{
    int32 remain = len;
    while (remain) {
	int nr,nxfr;
	if (remain > 32767)
	    nr = 32766;
	else
	    nr = (int)remain;
	nxfr = read(fd,buf,nr);
	if (nxfr <= 0) {
	    if (remain == len)
		return nxfr;
	    break;
	}
	remain -= nxfr;
	buf += nxfr;
    }
    return len-remain;
}

int32 longwrite(fd,buf,len)
int fd;
const char *buf;
unsigned int32 len;
{
    int32 remain = len;
    while (remain) {
	int nw,nxfr;
	if (remain > 32767)
	    nw = 32767;
	else
	    nw = (int)remain;
	nxfr = write(fd,buf,nw);
	if (nxfr <= 0) {
	    if (remain == len)
		return nxfr;
	    break;
	}
	remain -= nxfr;
	buf += nxfr;
    }
    return len-remain;
}

char *longmemcpy(dest,src,n)
char *dest;
const char *src;
unsigned int32 n;
{
    char *result = dest;
    while (n > 0) {
	unsigned int ncp;
	if (n > 32767)
	    ncp = 32767;
	else
	    ncp = (unsigned int)n;
	memcpy(dest,src,ncp);
	dest = dest + ncp;
	src = src + ncp;
	n -= ncp;
    }
    return result;
}
#endif /* SIZEOF_INT == 2 */

#undef malloc

#ifdef MSDOS
#include <alloc.h>

void _FAR *chk_malloc(len,file,line)
size_t len;
char *file;
int line;
{
    void _FAR *result = malloc(len);
    if (result == 0) {
	NALog(LOG_ERR,
	      "Out of memory while allocating %ld bytes at %s:%d\n",
	      (long)len,file,line);
	abort();
    }
    return result;
}

void _FAR *chk_farmalloc(len,file,line)
unsigned long len;
char *file;
int line;
{
    void _FAR *result = farmalloc(len);
    if (result == 0) {
	NALog(LOG_ERR,
	      "Out of memory while allocating %ld bytes at %s:%d\n",
	      (long)len,file,line);
	abort();
    }
    return result;
}
#else /* MSDOS */
void *chk_malloc(len,file,line)
size_t len;
char *file;
int line;
{
    void *result = malloc(len);
    if (result == 0) {
	NALog(LOG_ERR,"Out of memory while allocating %ld bytes at %s:%d\n",
	      (long)len,file,line);
	abort();
    }
    return result;
}
#endif /* !MSDOS */

void *realmalloc(len)
size_t len;
{
    return malloc(len);
}
