/* $Id: identify.c,v 1.15 1996/05/22 17:03:41 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Feb 16 23:44:39 EST 1992
 *
 * Revision History: $Log: identify.c,v $
 * Revision 1.15  1996/05/22  17:03:41  bst
 * Removed support for old SPW version 2 files -- could be confused with other types.
 *
 * Revision 1.14  1996/03/21  16:41:16  bst
 * Added include of sampfile.h
 *
 * Revision 1.13  1994/04/20  13:49:34  bst
 * Removed trigraph sequence from comment.
 *
 * Revision 1.12  1993/11/19  03:21:56  bst
 * Removed fcntl.h
 *
 * Revision 1.11  1993/08/10  02:31:01  bst
 * Use O_BINARY
 * Identify byte-swapped versions of SPW, SPPACK, ESPS files.
 *
 * Revision 1.10  1993/06/23  20:10:15  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.9  1993/06/23  03:37:22  bst
 * Don't check contents of buffer past part that was read.
 *
 * Revision 1.8  1993/05/18  19:44:55  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.7  1993/04/22  18:40:05  bst
 * Changed type of 'ibuf' from unsigned int to unsigned long.
 *
 * Revision 1.6  1993/03/01  16:46:18  bst
 * Added a coercion for THINK-C
 *
 * Revision 1.5  1992/12/28  22:23:13  bst
 * Added identification of SPW 3.0 files.
 *
 * Revision 1.4  1992/12/09  01:04:25  bst
 * Return 'mb ...' for unknown MacBinary files.
 *
 * Revision 1.3  1992/08/19  00:22:37  bst
 * Removed include of config.h (sysdefs.h gets it).
 *
 * Revision 1.2  1992/04/09  17:58:39  bst
 * Coerce first arg to strncmp() to const char *
 *
 * Revision 1.1  1992/02/17  04:45:04  bst
 * Initial revision
 *
 */
/* Identify a sound file and return its format name */

#include <stdio.h>
#include <string.h>
#include "sysdefs.h"
#include "debug.h"
#include "support.h"
#include "sampfile.h"

const char *SampFileIdentify(filename)
const char *filename;
{
    int fd = open(filename,O_RDONLY|O_BINARY);
    unsigned int32 ibuf[128];
    unsigned char *buf = (unsigned char *)ibuf;
    unsigned short *sbuf = (unsigned short *)ibuf;
    int nr;

    if (fd < 0) {
	NALog(LOG_ERR,"SampFileIdentify unable to open %s: %s\n",
	      filename,NAsyserr());
	return (const char *)0;
    }
    if ((nr=read(fd,(char *)ibuf,sizeof(ibuf))) < 0) {
	(void)close(fd);
	NALog(LOG_ERR,"Unable to read header from %s: %s\n",
	      filename, NAsyserr());
	return (const char *)0;
    }
    (void)close(fd);

    /* Check MAGIC numbers */
    if (strncmp((const char *)buf,".snd",4) == 0) {
	/* NeXT/SUN sound file */
	Debug("sampfile",1,"%s: NeXT/SUN .au file\n",filename);
	return "au";
    }
    if ((nr > 8*4) && (strncmp((const char *)buf,"FORM",4) == 0)) {
	/* IFF File */
	if (strncmp((const char *)&buf[8],"AIFF",4) == 0) {
	    Debug("sampfile",1,"%s: AIFF file\n",filename);
	    return "aiff";
	}
	else if (strncmp((const char *)&buf[8],"AIFC",4) == 0) {
	    Debug("sampfile",1,"%s: AIFC file\n",filename);
	    return "aifc";
	}
	else if (strncmp((const char *)&buf[8],"8SVX",4) == 0) {
	    Debug("sampfile",1,"%s: Amiga IFF file\n",filename);
	    return "8svx";
	}
	else {
	    NALog(LOG_WARNING,
		  "%s is an unidentifiable IFF file - assuming AIFF\n",
		    filename);
	    return "aiff";
	}
    }
    if ((nr >= 4) && (ntohl(ibuf[0]) == 107364)) {
	Debug("sampfile",1,"%s: IRCAM SoundFile\n",filename);
	return "ircam";
    }
    if ((nr >= 20) && ((ibuf[4] == 27182) || (ibuf[4] == 27162) ||
		       (ntohl(ibuf[4]) == 27182) || (ntohl(ibuf[4]) == 27162))) {
	Debug("sampfile",1,"%s: ESPS file\n",filename);
	return "esps";
    }
    if ((nr >= 256) && ((sbuf[126] == 16579) || (ntohs(sbuf[126]) == 16579))) {
	Debug("sampfile",1,"%s: SPPACK file\n",filename);
	return "sppack";
    }
    if ((nr >= 19) && (strncmp((const char *)buf,"Creative Voice File\032",19) == 0)) {
	Debug("sampfile",1,"%s: SoundBlaster VOC file\n",filename);
	return "voc";
    }
    if ((nr >= 4) && (strncmp((const char *)buf,"HCOM",4) == 0)) {
	Debug("sampfile",1,"%s: MAC HCOM data fork\n",filename);
	return "hcom";
    }
    if ((nr >= 132) && (strncmp((const char *)&buf[65],"FSSD",4) == 0)) {
	if (strncmp((const char *)&buf[128],"HCOM",4) == 0) {
	    Debug("sampfile",1,"%s: MAC HCOM file with MacBinary header\n",filename);
	    return "mbhcom";
	}
	else {
	    NALog(LOG_WARNING,
		  "%s is an unidentified MacBinary file\n",filename);
	    return "mb????";
	}
    }
    if ((nr >= 4) && (strncmp((const char *)buf,"NIST",4) == 0)) {
	Debug("sampfile",1,"%s: NIST/Sphere File\n",filename);
#ifdef ESPSFILES
	return "esps";
#else
	return "nist";
#endif
    }
    if ((nr >= 12) && (strncmp((const char *)buf,"$SIGNAL_FILE",12) == 0)) {
	Debug("sampfile",1,"%s: Comdisco SPW version 3 file\n",filename);
	return "spw3";
    }
#if 0
    if ((nr >= 16) && (ntohl(ibuf[3]) == 0x15)) {
	Debug("sampfile",1,"%s: Comdisco SPW version 2 file\n",filename);
	return "spw2";
    }
#endif
    return 0;
}

