/* $Id: getopt.c,v 1.5 1993/08/27 00:35:26 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Jan 26 23:39:49 EST 1992
 *
 * Revision History: $Log: getopt.c,v $
 * Revision 1.5  1993/08/27  00:35:26  bst
 * Compile conditional on not HAS_getopt.
 *
 * Revision 1.4  1993/08/10  02:30:35  bst
 * Use strcasecmp to check for "help"
 *
 * Revision 1.3  1993/07/05  15:10:01  bst
 * No const on 'opts' arg for alpha.
 *
 * Revision 1.2  1992/08/18  01:12:48  bst
 * Use <string.h> for declarations.
 *
 * Revision 1.1  1992/01/27  06:39:39  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "sysdefs.h"
#include "defaults.h"

int junk_getopt;	/* To avoid empty file warnings */

#ifndef HAS_getopt
int optind = 1;
char *optarg;

int getopt(argc, argv, opts)
int argc;
char *argv[];
const char *opts;
{
    static int sp = 1;
    int c;
    char *cp;
    
    if (sp == 1) {
	if (optind >= argc || argv[optind][0] != '-' || argv[optind][1] == '\0')
	    return(EOF);
	else if (strcmp(argv[optind], "--") == 0) {
	    optind++;
	    return(EOF);
	}
    }
    c = argv[optind][sp];
    if (c == ':' || (cp=strchr(opts, c)) == NULL) {
	if (strcasecmp(&argv[optind][sp],"help"))
	    fprintf(stderr, "%s: illegal option \"%c\"\n", argv[0], c);
	if (argv[optind][++sp] == '\0') {
	    optind++;
	    sp = 1;
	}
	return('?');
    }
    if (*++cp == ':') {
	if (argv[optind][sp+1] != '\0')
	    optarg = &argv[optind++][sp+1];
	else if (++optind >= argc) {
	    fprintf(stderr, "%s: option \"%c\" requires an argument\n", argv[0], c);
	    sp = 1;
	    return('?');
	} else
	    optarg = argv[optind++];
	sp = 1;
    } else {
	if (argv[optind][++sp] == '\0') {
	    sp = 1;
	    optind++;
	}
	optarg = NULL;
    }
    return(c);
}
#endif /* !HAS_getopt */

