/* $Id: filter.c,v 1.11 1994/05/26 15:15:43 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sat Jan 11 18:08:37 EST 1992
 *
 * Revision History: $Log: filter.c,v $
 * Revision 1.11  1994/05/26  15:15:43  bst
 * Fixed typo.
 *
 * Revision 1.10  1993/08/10  02:30:02  bst
 * int -> int32
 * Coerce malloc args to size_t
 *
 * Revision 1.9  1993/06/30  20:47:29  bst
 * Added missing initialization of *nf.
 *
 * Revision 1.8  1993/05/18  19:44:52  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.7  1992/11/06  01:45:46  bst
 * Cleanup warnings from GNU C 2.3.1
 *
 * Revision 1.6  1992/10/04  17:22:16  bst
 * Added 'filter.atten.%f.%f' .datlinkrc paramater.
 *
 * Revision 1.5  1992/02/11  18:19:06  bst
 * Use strchr() instead of index()
 *
 * Revision 1.4  1992/01/30  06:11:41  bst
 * Pass float 90.0 to GetFloatDefault() instead of int 90
 *
 * Revision 1.3  1992/01/22  21:04:24  bst
 * Added check for stopband attenuation between 40 and 120
 *
 * Revision 1.2  1992/01/18  04:11:50  bst
 * Set nf,f,l to zero if default filter is being used.
 *
 * Revision 1.1  1992/01/11  23:08:42  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "sysdefs.h"
#include "defaults.h"
#include "debug.h"

int GetFilterDefaults(atten,nf,f,l,ir,or)
float *atten;
unsigned int32 *nf;
float **f;
float **l;
double ir,or;
{
    const char *filtStr;
    char dreq[100];

    *atten = GetFloatDefault("filter.stopband.atten",90.0);
    sprintf(dreq,"filter.atten.%.0f.%.0f",ir,or);
    *atten = GetFloatDefault(dreq,*atten);
    if (*atten < 40) {
	NALog(LOG_WARNING,"Stopband attenuation must be >= 40 dB, check filter.stopband.atten in .datlinkrc\n");
	NALog(LOG_WARNING,"Using 90 dB for stopband attenuation\n");
	*atten = 90;
    }
    if (*atten > 120) {
	NALog(LOG_WARNING,"Stopband attenuation must be <= 120 dB, check filter.stopband.attn in .datlinkrc\n");
	NALog(LOG_WARNING,"Using 90 dB for stopband attenuation\n");
	*atten = 90;
    }
	
    sprintf(dreq,"filter.resp.%.0f.%.0f",ir,or);
    if ((filtStr = GetDefault(dreq,0)) != 0) {
	const char *p= filtStr;
	*nf = 0;
	while (p++) {
	    p = strchr(p,',');
	    (*nf)++;
	}
	p = filtStr;
	*l = (float *)malloc((size_t)(sizeof(**l)* *nf));
	*f = (float *)malloc((size_t)(sizeof(**f)* *nf));
	*nf = 0;
	while (1) {
	    (*f)[*nf] = atof(p);
	    p = strchr(p,'@');
	    if (p++ == 0) {
		NALog(LOG_ERR,"Syntax error in filter spec: %s\n",filtStr);
		return -1;
	    }
	    (*l)[(*nf)++] = atof(p);
	    p = strchr(p,',');
	    if (p++ == 0)
		break;
	}
    }
    else {
	*nf = 0;
	*f = *l = 0;
    }
    return 0;
}

