/* $Id: esps.c,v 1.27 1996/10/11 17:42:40 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Dec 16 00:40:34 EST 1991
 *
 * Revision History: $Log: esps.c,v $
 * Revision 1.27  1996/10/11  17:42:40  bst
 * Modified to compile under 5.1
 *
 * Revision 1.26  1994/04/25  20:30:39  bst
 * Fixed arg types for *_wrheader(), *_write*()
 *
 * Revision 1.25  1993/08/30  18:02:07  bst
 * Removed include of config.h
 *
 * Revision 1.24  1993/08/10  02:29:36  bst
 * Coerce %l args to long.
 * Use binary opens under DOS.
 *
 * Revision 1.23  1993/07/08  18:35:55  bst
 * Use SamplesToBytes(), BytesToSamples() macros.
 *
 * Revision 1.22  1993/06/23  20:10:15  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.21  1993/06/09  14:15:00  bst
 * Always compile in debug_level to avoid warnings about empty file.
 *
 * Revision 1.20  1993/05/18  19:44:34  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.19  1993/04/22  03:23:21  bst
 * Added include of formats.h
 *
 * Revision 1.18  1993/04/12  02:13:45  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.17  1993/03/24  19:40:24  bst
 * Added include of naversion.h
 *
 * Revision 1.16  1993/02/18  21:38:16  bst
 * Moved config.h to include/
 * Let config.h determine if file should be compiled rather than
 *    using '#ifndef macintosh'
 *
 * Revision 1.15  1992/12/09  01:04:07  bst
 * Modified set of ESPS includes.
 *
 * Revision 1.14  1992/05/12  18:53:58  bst
 * Use 'sampleSize' to convert from bytes to num_records.
 * Fixed bug in checking if num_channels > 2
 *
 * Revision 1.13  1992/05/10  19:02:50  bst
 * Added encoding, precision.
 *
 * Revision 1.12  1992/04/09  17:57:17  bst
 * Changed strings.h to string.h
 * Use strchr() instead of index().
 *
 * Revision 1.11  1992/04/07  22:56:45  bst
 * Fixed format error in Debug() message
 *
 * Revision 1.10  1992/03/02  04:00:18  bst
 * Added missing arg to error printf.
 *
 * Revision 1.9  1992/02/17  04:47:59  bst
 * Removed ESPS_wrtrailer()
 *
 * Revision 1.8  1992/02/11  18:18:48  bst
 * Don't compile any of this file on Mac.
 *
 * Revision 1.7  1992/02/08  03:10:34  bst
 * Fixed cast warning.
 *
 * Revision 1.6  1992/01/30  04:06:38  bst
 * Used '#ifdef' instead of '#if' for ESPSFILES
 * Added inhibit_hdr_date() to workaround write_header() bug.
 *
 * Revision 1.5  1992/01/28  05:49:54  bst
 * Added include of ../config.h
 *
 * Revision 1.4  1992/01/27  03:56:47  bst
 * Check if MajorRevision macro is defined before using it.
 * Added ESPS_aborted() - send_xwaves() is here now instead of in close()
 *
 * Revision 1.3  1992/01/24  05:04:33  bst
 * Fixed to handle FT_SD files.
 * Added record capability.
 * Handle SIGUSR1
 *
 * Revision 1.2  1992/01/22  21:04:09  bst
 * Use 'channels' instead of 'left','right'
 *
 * Revision 1.1  1991/12/16  05:41:13  bst
 * Initial revision
 *
 */
#include "naversion.h"
int debug_level;	/* Make sure file always has something in it */
#ifdef ESPSFILES
#include <stdio.h>
#include <string.h>
#include <signal.h>
#define NOSPSINCLUDE
#include <esps/esps.h>
#include <esps/header.h>
#include <esps/fea.h>
#include <esps/feasd.h>
#include <esps/ftypes.h>
#include "sysdefs.h"
#include "debug.h"
#include "sampfile.h"
#include "formats.h"
#include "support.h"

/* In ESPS 5.1, we have prototypes for these (and they define 'ARGS') */
#ifndef ARGS
extern void free_header P((struct header *hd, unsigned int32 flags, char *ptr));
#endif

extern int send_xwaves2 P((char *host, int port, char *str, int verbose));
extern int size_rec P((struct header *));
extern struct header *sdtofea P((struct header *hd));

/*
 * Input operations
 */

struct esps_private {
    struct header *hdr;
    struct feasd feasd;
};

#define HD (((struct esps_private *)this->private)->hdr)
#define FEASD (((struct esps_private *)this->private)->feasd)

/* Open a file for reading and read it's header */
int ESPS_open(this)
SampFile *this;
{
    if (this->name && strcmp(this->name,"-")) {
#ifdef MSDOS
	this->io = fopen(this->name,"rb");
#else /* MSDOS */
	this->io = fopen(this->name,"r");
#endif /* !MSDOS */
	if (this->io == NULL)
	    return -1;
    }
    else
	this->io = stdin;

    return (*this->rdheader)(this);
}

/* Read the header from the file */
int ESPS_rdheader(this)
SampFile *this;
{
    int num_channels;

    HD = read_header(this->io);
    if (HD == NULL) {
	char defheader[100];
	NALog(LOG_WARNING,"%s is not an ESPS file\n",this->name);
	strcpy(defheader,"DEF_HEADER=");
	strcat(defheader,getenv("ESPS_BASE"));
	strcat(defheader,"/lib/waves/files/def_head.feasd");
	NALog(LOG_WARNING,"Using %s for ESPS header\n",defheader);
	if (putenv(defheader)) {
	    NALog(LOG_ERR,"Unable to set %s\n",defheader);
	    return -1;
	}
	HD = read_header(this->io);
	if (HD == NULL) {
	    NALog(LOG_ERR,"Still unable to open %s\n",this->name);
	    return -1;
	}
    }
    if (HD->common.type == FT_SD) {
	/* Convert into a FEA_SD file */
	struct header *fea_sd;
	Debug("ESPS",1,"Converting %s from FT_SD to FEA_SD\n",this->name);
	fea_sd = sdtofea(HD);
	free_header(HD,0L,0);
	HD = fea_sd;
    }
    if (HD->hd.fea->fea_type != FEA_SD) {
	NALog(LOG_ERR,"Unable to read %s which is a FEA file with fea_type=%d\n",
		this->name,HD->hd.fea->fea_type);
	return -1;
    }
    this->srate = *get_genhd_d("record_freq",HD);

    num_channels = get_fea_siz("samples",HD,(short *)NULL,(long int **)NULL);
    if (num_channels == 1) 
	this->channels = 0;
    else if (num_channels == 2)
	this->channels = 3;
    else {
	NALog(LOG_ERR,"Unable to read FEA_SD file with %d channels of data\n",
		num_channels);
	return -1;
    }

    FEASD.data_type = SHORT;
    this->precision = 16;	/* Use 16 bit transfers regardless */
    this->encoding = 0;
    this->sampleSize = this->precision*num_channels;
    FEASD.num_channels = num_channels;
    FEASD.ptrs = 0;

    Debug("ESPS",1,"Read header from ESPS file %s: srate=%f, numchannels=%d\n",
	  this->name,this->srate,num_channels);
    return 0;
}

/* Seek input file to given sample */
int ESPS_seek(this,sampleNumber)
SampFile *this;
unsigned int32 sampleNumber;
{
    Debug("ESPS",1,"Seek(%ld), size_rec = %d, cursample = %ld\n",
	  (long)sampleNumber,size_rec(HD),(long)this->currentSample);
    skiprec(this->io,(long int)(sampleNumber-this->currentSample),size_rec(HD));
    this->currentSample = sampleNumber;
    return 0;
}

/* Read samples */
int32 ESPS_read(this,buf,nbytes)
SampFile *this;
byte *buf;
int32 nbytes;
{
    int32 rval;

    FEASD.num_records = BytesToSamples(nbytes,this->sampleSize);
    FEASD.data = (char *)buf;
    rval = get_feasd_recs(&FEASD,0,FEASD.num_records,HD,this->io);
    Debug("ESPS",1,"get_feasd_recs->%ld, nbytes=%ld, num_rec=%ld, num_chan=%ld\n",
	  (long)rval,(long)nbytes,(long)FEASD.num_records,(long)FEASD.num_channels);
    this->currentSample += rval;
    return SamplesToBytes(rval,this->sampleSize);
}

/*
 * Output operations
 */

/* Create an output file */
int ESPS_create(this)
SampFile *this;
{
    if ((this->io = fopen(this->name,
#ifdef MSDOS
			  "wb"
#else
			  "w"
#endif
			  )) == NULL)
	return -1;

    return 0;
}

/* Write the header */
int ESPS_wrheader(this,nsamples)
SampFile *this;
unsigned int32 nsamples;
{
    int num_channels = (this->channels==3)?2:1;
    double start_time = 0.0;
    char buf[100];
    int datatype;

    if (this->encoding == -1)
	this->encoding = 0;
    if (this->precision == -1)
	this->precision = 16;

    if (this->encoding == 1)
	datatype = FLOAT;
    else if (this->encoding != 0) {
	NALog(LOG_ERR,
		"Cannot only create ESPS files with linear or IEEE encodings.\n");
	return -1;
    }
    else if (this->precision == 16)
	datatype = SHORT;
    else if (this->precision == 8)
	datatype = BYTE;
    else if (this->precision == 32)
	datatype = LONG;
    else {
	NALog(LOG_ERR,
		"Can only create ESPS files with 8, 16, or 32 bit precision\n");
	return -1;
    }
    this->sampleSize = this->precision*num_channels;

    if ((HD = new_header(FT_FEA)) == NULL) {
	NALog(LOG_ERR,"Unable to allocate header for %s\n",this->name);
	return -1;
    }
    /* Set-up header... */
    if (init_feasd_hd(HD,datatype,num_channels,&start_time,NO,this->srate) != 0) {
	NALog(LOG_ERR,"Internal error: init_feasd_hd error\n");
	return -1;
    }
    /* Add comment */
    add_comment(HD,this->cmd);
    /* Add additional info */
    /* Get program name */
    strcpy(buf,this->cmd);
    if (strchr(buf,' '))
	*strchr(buf,' ') = 0;
    strncpy(HD->common.prog,buf,PROGSIZE);
    /* Set revision of NetAudio */
#ifdef MajorRevision
    sprintf(buf,"%d.%02d",MajorRevision,MinorRevision);
    strncpy(HD->common.vers,buf,VERSIONSIZE);
#endif

    /* Seems to be a bug in write_header() - inhibit_hdr_date() avoids it */
    inhibit_hdr_date();
    write_header(HD,this->io);
    Debug("ESPS",1,"Wrote header to %s, nsamples=%d, num_channels=%d, srate=%f\n",
	  this->name,nsamples,num_channels,this->srate);

    FEASD.data_type = datatype;
    FEASD.num_channels = num_channels;
    FEASD.ptrs = 0;

    return 0;
}

/* Write samples */
int32 ESPS_write(this,buf,nbytes)
SampFile *this;
const byte *buf;
int32 nbytes;
{
    int32 rval;

    FEASD.num_records = BytesToSamples(nbytes,this->sampleSize);
    FEASD.data = (char *)buf;
    rval = put_feasd_recs(&FEASD,0,FEASD.num_records,HD,this->io);
    Debug("ESPS",1,"put_feasd_recs->%ld, nbytes=%ld, num_rec=%ld, num_chan=%ld\n",
	  (long)rval,(long)nbytes,(long)FEASD.num_records,(long)FEASD.num_channels);
    if (rval != 0)
	return -1;
    this->currentSample += FEASD.num_records;
    return SamplesToBytes(FEASD.num_records,this->sampleSize);
}

/* Close file */
int ESPS_close(this)
SampFile *this;
{
    fclose(this->io);
    return 0;
}

int ESPS_aborted(this,sampleNumber)
SampFile *this;
unsigned int32 sampleNumber;
{
    char str[100];
    NALog(LOG_INFO,"ESPS_aborted(%d)\n",sampleNumber);
    sprintf(str,"set da_location %d\n",sampleNumber);
    send_xwaves2(NULL,0,str,0);
    fclose(this->io);
    return 0;
}

/* 
 * Set up for ESPS
 */
void ESPS_construct(this)
SampFile *this;
{
    this->open = ESPS_open;
    this->create = ESPS_create;
    this->wrheader = ESPS_wrheader;
    this->rdheader = ESPS_rdheader;
    this->write = ESPS_write;
    this->read = ESPS_read;
    this->seek = ESPS_seek;
    this->close = ESPS_close;
    this->aborted = ESPS_aborted;
    this->private = (void *)malloc(sizeof(struct esps_private));
}

#endif /* ESPSFILES==1 */
