/* $Id: dspfloat.c,v 1.7 1993/08/27 00:41:58 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Tue Nov 3 22:34:49 EST 1992
 *
 * Revision History: $Log: dspfloat.c,v $
 * Revision 1.7  1993/08/27  00:41:58  bst
 * Use HAS_is* defines.
 *
 * Revision 1.6  1993/08/10  02:29:27  bst
 * COERCE %L ARGS TO LONG
 *
 * Revision 1.5  1993/06/23  20:08:36  bst
 * Added include of dat_types.h
 * Changed 'long' to 'int32'
 *
 * Revision 1.4  1993/06/09  14:14:38  bst
 * Made use of isnan(), isinf() conditional on HAS_IEEE.
 *
 * Revision 1.3  1993/05/24  20:27:50  bst
 * Handle IEEE infinities, NaNs.
 *
 * Revision 1.2  1993/04/12  02:13:25  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.1  1992/11/04  04:02:10  bst
 * Initial revision
 *
 */
#include <math.h>
#include "syscap.h"
#include "dat_types.h"
#include "support.h"
#include "debug.h"

/* Convert a DSP floating point number into a native float */
double NativeFloat(x)
dsp32float x;   /* Uses host byte-order, not necessarily the same as DSP */
{
    double result;
    int32 mantissa = (x>>8)&0x7fffff;
    int32 expo = (x&0xff)-128;
    int32 sign = (x>>31)&1;
    if (expo == -128)
	result = 0;
    else if (sign)
	result = (-2+mantissa*1.0/(1L<<23))*pow(2.0,expo*1.0);
    else
	result = (1+mantissa*1.0/(1L<<23))*pow(2.0,expo*1.0);

    Debug("NativeFloat",10,"%08lx -> %f\n",(long)x,result);
    return result;
}

/* Convert a native floating point number into a DSP float stored
   in an int using host byte-order */
dsp32float DSPFloat(x)
double x;
{
    int32 sign;
    int32 mantissa;
    int32 expo;
    dsp32float iresult;
    double origX = x;

    if (x == 0) {
	sign = mantissa = expo = 0;
    }
#ifdef HAS_isinf
    else if (isinf(x)) {
	NALog(LOG_ERR,"DSPFloat() called with infinity as arg\n");
	if (x < 0) {
	    sign = 1;
	    mantissa = 0;
	    expo = 255;
	}
	else {
	    sign = 0;
	    mantissa = (1L<<23)-1;
	    expo = 255;
	}
    }
#endif /* HAS_isinf */
#ifdef HAS_isnan
    else if (isnan(x)) {
	NALog(LOG_ERR,"DSPFloat() called with a NaN\n");
	sign = mantissa = expo = 0;
    }
#endif /* HAS_isnan */
    else if (x < 0) {
	sign = 1;
	expo = 128;
	while (x <= -2) {
	    x/=2;
	    expo++;
	}
	while (x > -1) {
	    x*=2;
	    expo--;
	}
	mantissa = (x+2)*(1L<<24);
    } else {
	/* x > 0 */
	sign = 0;
	expo = 128;
	while (x < 1) {
	    x*=2;
	    expo--;
	}
	while (x >= 2) {
	    x/=2;
	    expo++;
	}
	mantissa = (x-1)*(1L<<23);
    }
    iresult = (sign<<31)|(mantissa<<8)|expo;
    Debug("DSPFloat",1,"%f -> %08lx\n",origX, (long)iresult);
    return iresult;
}
