/* $Id: csrate.c,v 1.2 1994/04/25 20:30:08 bst Exp $
 *
 * Copyright 1993 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sat Oct 30 16:21:31 EDT 1993
 *
 * Revision History: $Log: csrate.c,v $
 * Revision 1.2  1994/04/25  20:30:08  bst
 * Made GetRateFromCS() arg unsigned char.
 *
 * Revision 1.1  1993/11/01  21:50:37  bst
 * Initial revision
 *
 */
#include <stdio.h>
#include "support.h"
#include "debug.h"

/* Compute sampling rate from channel status bits */
unsigned int GetRateFromCS(cstatus)
unsigned char cstatus[24];
{
    if (cstatus[0] & 1) {
	/* PRO Format */
	switch (cstatus[0]&0xc0) {
	  case 0:
	  case 0x80:
	    return 48000;
	  case 0x40:
	    return 44100;
	  case 0xc0:
	    return 32000;
	}
    }
    else {
	/* Consumer format */
	switch (cstatus[3] & 0xf) {
	  case 0:
	    return 44100;
	  case 2:
	    return 48000;
	  case 3:
	    return 32000;
	  default:
	    NALog(LOG_WARNING,
		   "Bad value of channel status sampling rate - assuming 48,000 samples/second\n");
	    return 48000;
	}
    }
    /* NOTREACHED */
    return 0; 
}

