/* $Id: convert.c,v 1.5 1993/10/05 21:46:36 bst Exp $
 *
 * Copyright 1993 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sat Aug 7 17:49:25 EDT 1993
 *
 * Revision History: $Log: convert.c,v $
 * Revision 1.5  1993/10/05  21:46:36  bst
 * Use HAS_* macros.
 *
 * Revision 1.4  1993/10/05  19:38:59  bst
 * Mask out low 16 bits of int args to htons(), ntohs().
 *
 * Revision 1.3  1993/10/05  19:32:50  bst
 * Make htons(), ntohs() return ints.
 *
 * Revision 1.2  1993/10/05  14:51:56  bst
 * Made args to htons() and ntohs() int instead of short (for non-ANSI compat)
 *
 * Revision 1.1  1993/08/10  02:46:04  bst
 * Initial revision
 *
 */
#include "support.h"

void SwapUShort(x)
unsigned short *x;
{
    *x = (*x<<8)|((*x>>8)&0xff);
}

void SwapULong(x)
unsigned int32 *x;
{
    *x = ((*x<<24)&0xff000000)|((*x<<8)&0x00ff0000)|
	((*x>>8)&0x0000ff00)|((*x>>24)&0xff);
}

void SwapShort(x)
short *x;
{
    SwapUShort((unsigned short *)x);
}

void SwapLong(x)
int32 *x;
{
    SwapULong((unsigned int32 *)x);
}

#ifndef HAS_ntohl
unsigned int32 ntohl(x)
unsigned int32 x;
{
    byte *bx = (byte *)&x;
    return (((unsigned int32)bx[0])<<24)|(((unsigned int32)bx[1])<<16)|(((unsigned int32)bx[2])<<8)|bx[3];
}
#endif /* !HAS_ntohl */

#ifndef HAS_htonl
unsigned int32 htonl(x)
unsigned int32 x;
{
    byte *bx = (byte *)&x;
    return (((unsigned int32)bx[0])<<24)|(((unsigned int32)bx[1])<<16)|(((unsigned int32)bx[2])<<8)|bx[3];
}
#endif /* !HAS_htonl */

#ifndef HAS_ntohs
unsigned int ntohs(x)
unsigned int x;
{
    unsigned short sx = x&0xffff;
    byte *bx = (byte *)&sx;
    return (bx[0]<<8)|bx[1];
}
#endif /* !HAS_ntohs */

#ifndef HAS_htons
unsigned int htons(x)
unsigned int x;
{
    unsigned short sx = x&0xffff;
    byte *bx = (byte *)&sx;
    return (bx[0]<<8)|bx[1];
}
#endif /* !HAS_htons */
