/* $Id: coff.h,v 1.5 1993/06/23 20:22:05 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun May 17 16:45:07 EDT 1992
 *
 * Revision History: $Log: coff.h,v $
 * Revision 1.5  1993/06/23  20:22:05  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.4  1993/01/29  21:56:11  bst
 * Never use AT&T DSP32C include files.
 * Added some macro definitions.
 * Added 'doswap' arg to ldgetname().
 *
 * Revision 1.3  1992/12/22  16:30:32  bst
 * Added checking of COFF magic numbers.
 *
 * Revision 1.2  1992/07/11  20:24:43  bst
 * Added relocation structure and constants.
 *
 * Revision 1.1  1992/05/17  20:45:11  bst
 * Initial revision
 *
 */
/* Interface to COFF I/O routins */

#define SUCCESS 1

struct filehdr {
	unsigned short	f_magic;	/* magic number */
	unsigned short	f_nscns;	/* number of sections */
	int32		f_timdat;	/* time & date stamp */
	int32		f_symptr;	/* file pointer to symtab */
	int32		f_nsyms;	/* number of symtab entries */
	unsigned short	f_opthdr;	/* sizeof(optional hdr) */
	unsigned short	f_flags;	/* flags */
	};
typedef struct filehdr FILHDR;

struct	ldfile {
	int	_fnum_;		/* so each instance of an LDFILE is unique */
	FILE	*ioptr;		/* system I/O pointer value */
	int32	offset;		/* absolute offset to the start of the file */
	FILHDR	header;		/* the file header of the opened file */
	unsigned short	type;		/* indicator of the type of the file */
};
typedef struct ldfile LDFILE;

struct scnhdr {
	char		s_name[8];	/* section name */
	int32		s_paddr;	/* physical address */
	int32		s_vaddr;	/* virtual address */
	int32		s_size;		/* section size */
	int32		s_scnptr;	/* file ptr to raw data for section */
	int32		s_relptr;	/* file ptr to relocation */
	int32		s_lnnoptr;	/* file ptr to line numbers */
	unsigned short	s_nreloc;	/* number of relocation entries */
	unsigned short	s_nlnno;	/* number of line number entries */
	int32		s_flags;	/* flags */
	};
#define	SCNHDR	struct scnhdr
#define  SYMNMLEN	8
/*		Number of characters in a file name */
#define  FILNMLEN	14
/*		Number of array dimensions in auxiliary entry */
#define  DIMNUM		4

#define  DSPMAGIC	0540
#define	 DSP32CMAGIC	0542
#define	 DSP32MAGICNEW	0544

#define ISCOFF(x)  (((x)==DSPMAGIC) || ((x)==DSP32CMAGIC) || ((x)==DSP32MAGICNEW))

struct syment
{
	union
	{
		char		_n_name[SYMNMLEN];	/* old COFF version */
		struct
		{
			int32	_n_zeroes;	/* new == 0 */
			int32	_n_offset;	/* offset into string table */
		} _n_n;
		char		*_n_nptr[2];	/* allows for overlaying */
	} _n;
	int32			n_value;	/* value of symbol */
	short			n_scnum;	/* section number */
	unsigned short		n_type;		/* type and derived type */
	char			n_sclass;	/* storage class */
	char			n_numaux;	/* number of aux. entries */
} ;
#define SYMESZ 18
#define n_name _n._n_name
#define n_zeroes _n._n_n._n_zeroes
#define n_offset _n._n_n._n_offset

typedef struct syment SYMENT;
#define  C_EXT           2     /* external symbol */

struct reloc {
	int32	r_vaddr;	/* (virtual) address of reference */
	int32	r_symndx;	/* index into symbol table */
	unsigned short	r_type;		/* relocation type */
	};

/*
 *   relocation types for all products and generics
 */

/*
 * All generics
 *	reloc. already performed to symbol in the same section
 */
#define  R_ABS		0
#define  R_RLCINST	28

/*
 * DSP32 and DSP32C generics
 *	16-bit reference
 *	24-bit reference (instruction and data)
 *	16-bit reference to be relocated and then negated
 */
/* first four are unsigned values */
#define	R_DSP_16	034	/* must have same value as R_RLCINST above (28) */
#define	R_DSP_NEG16	035
#define	R_DSP_24I	036
#define	R_DSP_24D	037
/* these four are signed values */
#define	R_DSP_16S	040	
#define	R_DSP_NEG16S	041
#define	R_DSP_24IS	042
#define	R_DSP_24DS	043
/* these four are with parity */
#define	R_DSP_16P	044
#define	R_DSP_NEG16P	045
#define	R_DSP_16SP	046
#define	R_DSP_NEG16SP	047
/* these are for relocatable pc relative gotos */
#define R_DSP_16_PC	050
#define R_DSP_16S_PC	051
#define R_DSP_16P_PC	052
#define R_DSP_16SP_PC	053
#define R_DSP_24I_PC	054
#define R_DSP_24IS_PC	055

#define RELSZ 10

extern "C" {
    LDFILE *ldopen(const char *, LDFILE *);
    /*    int ldahread( LDFILE *, ARCHDR *); */
    int ldfhread( LDFILE *, FILHDR *);
    int ldshread( LDFILE *, unsigned short, SCNHDR *);
    int ldnshread( LDFILE *, char *, SCNHDR *);
    int ldnsseek( LDFILE *, char *);
    int ldsseek( LDFILE *, unsigned short);
    int ldtbread( LDFILE *, int32, SYMENT *);
    int ldnrseek( LDFILE *, char *);
    int ldrseek( LDFILE *, unsigned short);
    int ldnlseek( LDFILE *, char *);
    int ldlseek( LDFILE *, unsigned short);
    int ldtbseek( LDFILE *);
/*    int ldlread( LDFILE *, int32, unsigned short, LINENO *); */
    int ldlinit( LDFILE *, int32);
/*    int ldlitem( LDFILE *, unsigned short, LINENO *); */
    int ldohseek( LDFILE *); 
    void ldaclose( LDFILE *); 
/* Get the name of a symbol */
    char *ldgetname( LDFILE *, SYMENT *, int doswap);
    void underline( char *); 
    void print_main(char *, SYMENT); 
    void prtflags(int32); 
/*    void det_auxent(SYMENT, AUXENT, LDFILE *, char *); */
    void det_type(SYMENT); 
    void det_sclass(SYMENT); 
    int32 sgetl( char *); 
}
