/* $Id: xdrio.c,v 2.6 1993/10/26 16:15:45 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:58 EST 1991
 *
 * Revision History: $Log: xdrio.c,v $
 * Revision 2.6  1993/10/26  16:15:45  bst
 * Added coercions for GCC 2.5.0
 *
 * Revision 2.5  1993/10/06  16:28:39  bst
 * Fixed incorrect code in _NAHexDump().
 *
 * Revision 2.4  1993/06/16  17:06:08  bst
 * Added include of string.h.
 *
 * Revision 2.3  1993/05/18  19:42:05  bst
 * Use NALog() to log/print errors and warnings.
 * Use DebugCont() for continuation of debug messages.
 *
 * Revision 2.2  1992/04/07  22:54:18  bst
 * Use DebugCheck() instead of Debug() to avoid format warning.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include <string.h>
#include "NAlibint.h"

void _NAHexDump(buf,len)
char *buf;
int len;
{
    int i;
    for (i=0;i<len;i+=16) {
	int j;
	char tbuf[60];
	tbuf[0] = 0;
       	for (j=0;(j<16)&&(i+j<len);j++)
	    sprintf(&tbuf[j*3],"%02x ",(unsigned char)buf[i+j]);
	strcat(tbuf,"\n");
	DebugCont(tbuf);
    }
}

/* Routines to read/write XDR buffer to sockets */
int _NACtlSockRead(fd,buf,len)
int fd;
char *buf;
int len;
{
    int nr;
    Debug("sockread",10,"Reading %d bytes from socket\n",len);
    nr = read(fd,buf,(unsigned int)len);
    Debug("sockread",4,"Read %d/%d bytes from socket\n",nr,len);
    if (DebugCheck("sockread",8))
	_NAHexDump(buf,nr);
    if (nr == 0)
	return -1;
    return nr;
}

int _NACtlSockWrite(fd,buf,len)
int fd;
char *buf;
int len;
{
    int nw = write(fd,buf,(unsigned int)len);
    Debug("sockwrite",4,"Wrote %d/%d bytes to socket\n",nw,len);
    if (DebugCheck("sockwrite",8))
	_NAHexDump(buf,len);
    if (nw == 0)
	return -1;
    return nw;
}
